/**
 * This module can be loaded separately from whisper/hermes in order to get messages for current user and check experience overrides
 */
define('atlassian-whisper/messages', [
    "require"
], function (require) {
    "use strict";

    var WhisperMessagesData = require("wrm/data").claim("com.atlassian.whisper.atlassian-whisper-plugin:atlassian-whisper-messages.WhisperMessagesData");
    var whisperMessages = WhisperMessagesData && WhisperMessagesData.messages;

    var userLocale = (document.querySelector("meta[name=ajs-user-locale]") || {}).content || "en";
    var isEn = userLocale.indexOf("en") === 0;

    return {
        getMessages: function() {
            return whisperMessages;
        },

        hasOverride: function(experienceId) {
            return (whisperMessages || []).some(function(message) {
                return (message.experienceOverrides || []).some(function(overrideId) {
                    return overrideId === experienceId;
                }) && ((isEn && message.defaultEnglish !== false) || Object.keys(message.componentInLanguage||{}).some(function(componentLocale) {
                    return userLocale.indexOf(componentLocale) === 0;
                }));
            });
        }
    }
});