AJS.test.require([
    'com.atlassian.whisper.atlassian-whisper-plugin:atlassian-whisper-messages'
], function () {

    var $ = require('jquery');

    module('WhisperMessages API', {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.context = AJS.test.mockableModuleContext();
            this.context.mock('wrm/data', {
                claim: sinon.stub()
            });
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test('hasOverride should return false when some message is present', function (assert) {
        prepareMessages.call(this);

        var whisperMessages = this.context.require('atlassian-whisper/messages');

        assert.ok(whisperMessages.hasOverride("existant-override-1"));
        assert.ok(whisperMessages.hasOverride("existant-override-2"));
        assert.ok(!whisperMessages.hasOverride("non-existant-override-1"));
        assert.ok(!whisperMessages.hasOverride("non-existant-override-2"));
    });

    test('hasOverride should return false when translation not available', function (assert) {
        prepareMessages.call(this);
        $('#qunit-fixture').html('<meta name="ajs-user-locale" content="de_DE" />');

        var whisperMessages = this.context.require('atlassian-whisper/messages');

        assert.ok(!whisperMessages.hasOverride("existant-override-1"));
        assert.ok(!whisperMessages.hasOverride("existant-override-2"));
        assert.ok(!whisperMessages.hasOverride("non-existant-override-1"));
        assert.ok(!whisperMessages.hasOverride("non-existant-override-2"));
    });

    test('hasOverride should return true when translation available', function (assert) {
        prepareMessages.call(this, function(messages) { return (messages[0].componentInLanguage = { "de_DE": {} }, messages); });
        $('#qunit-fixture').html('<meta name="ajs-user-locale" content="de_DE" />');

        var whisperMessages = this.context.require('atlassian-whisper/messages');

        assert.ok(whisperMessages.hasOverride("existant-override-1"));
        assert.ok(!whisperMessages.hasOverride("existant-override-2"));
        assert.ok(!whisperMessages.hasOverride("non-existant-override-1"));
        assert.ok(!whisperMessages.hasOverride("non-existant-override-2"));
    });

    test ('hasOverride should return false when defaultEnglish set to false', function(assert) {
        prepareMessages.call(this, function(messages) { return (messages[0].defaultEnglish = false, messages); });

        var whisperMessages = this.context.require('atlassian-whisper/messages');

        assert.ok(!whisperMessages.hasOverride("existant-override-1"));
        assert.ok(whisperMessages.hasOverride("existant-override-2"));
        assert.ok(!whisperMessages.hasOverride("non-existant-override-1"));
        assert.ok(!whisperMessages.hasOverride("non-existant-override-2"));
    });

    test ('hasOverride should return true when defaultEnglish set to true', function(assert) {
        prepareMessages.call(this, function(messages) { return (messages[0].defaultEnglish = true, messages); });

        var whisperMessages = this.context.require('atlassian-whisper/messages');

        assert.ok(whisperMessages.hasOverride("existant-override-1"));
        assert.ok(whisperMessages.hasOverride("existant-override-2"));
        assert.ok(!whisperMessages.hasOverride("non-existant-override-1"));
        assert.ok(!whisperMessages.hasOverride("non-existant-override-2"));
    });

    var prepareMessages = function (inject) {
        inject = inject || function(value) { return value; };
        var messagesData = {
            messages: inject([{
                id: "test-message-1",
                experienceOverrides: ["existant-override-1", "existant-override-3"]
            }, {
                id: "test-message-2",
                experienceOverrides: ["existant-override-2", "existant-override-4"]
            }])
        };

        var WRMData = this.context.require('wrm/data');
        WRMData.claim.withArgs("com.atlassian.whisper.atlassian-whisper-plugin:atlassian-whisper-messages.WhisperMessagesData").returns(messagesData);
    };
});