define('atlassian-whisper/bootstrap', [
    "wrm/require"
], function (
    wrmRequire
) {
    return function () {
        var WhisperData = require("wrm/data").claim("com.atlassian.whisper.atlassian-whisper-plugin:atlassian-whisper-bootstrap.WhisperData");
        if (!WhisperData || WhisperData.hasMessages !== true) {
            return;
        }

        var hermesInit = function() {
            try {
                localStorage.setItem("hermes.config.delivery-url", AJS.contextPath() + "/rest/whisper/1/messages");
                localStorage.setItem("hermes.config.store-url", AJS.contextPath() + "/rest/whisper/1/properties");
            } catch (e) {
                return;
            }

            require(["atlassian-whisper/hermes-init"], function (hermesInit) { // eslint-disable-line module-checks/no-invalid-require
                hermesInit(WhisperData);
            }, undefined, WhisperData.syncInit);
        };

        if (WhisperData.syncInit) {
            hermesInit();
        } else {
            AJS.$(function() {
                wrmRequire("wr!com.atlassian.whisper.atlassian-whisper-plugin:atlassian-whisper-hermes", hermesInit)
            });
        }
    }
});