define('jira/user-profile-plugin/profile-details', [
    'atlassian/libs/uri-1.14.1',
    'atlassian/libs/factories/backbone-1.0.0',
    'atlassian/libs/underscore-1.5.2',
    'jquery'
], function
(
    URI,
    backboneFactory,
    _,
    jQuery
) {
    var UserProfile = JIRA.UserProfile;
    /**
     * View for the avatar details on the view profile page.
     * @class JIRA.UserProfile.ProfileDetails
     * @extends Backbone.View
     */
    return backboneFactory(_, jQuery).View.extend(
    /** @lends JIRA.UserProfile.ProfileDetails# */
    {
        /**
         * @constructs
         * @param {object} options
         * @param {string} [options.baseUrl] the JIRA base URL (default: AJS.params.baseURL)
         */
        initialize: function(options) {
            Backbone.View.prototype.initialize.call(this, options);
            this._gravatarLozengeDiv = this.$('.gravatar-lozenge-container');
            this.gravatarRegex = new RegExp("gravatar\.com\/avatar\/.*");
            this.onAvatarChanged(this.$('.avatar-image').attr('src'));
        },

        /**
         * Callback for when the avatar has changed.
         *
         * @param {string} avatarSrc location of new avatar image (absolute URL)
         */
        onAvatarChanged: function(avatarSrc) {
            if (!_.isEmpty(avatarSrc)) {
                this._renderGravatarLozenge(avatarSrc);
                this._updateImageInProfileHeader(avatarSrc);
            }
        },

        /**
         * Shows the Gravatar lozenge under the user's avatar if the avatar is an image outside the JIRA base url.
         *
         * @param {string} avatarSrc location of new avatar image (absolute URL)
         * @private
         */
        _renderGravatarLozenge: function(avatarSrc) {
            var avatarURI = new URI(avatarSrc);

            if (this.gravatarRegex.test(avatarURI.normalize().toString()))
            {
                this._gravatarLozengeDiv.html(UserProfile.gravatarLozengeView({ userEmail: jQuery('#up-d-email').find('a').text() }));
                this.$('.gravatar-lozenge').tooltip({ gravity: 'w' });
            } else {
                this._gravatarLozengeDiv.empty();
            }
        },

        /**
         * Updates the avatar in the JIRA user profile header. This doesn't strictly lie inside the profile details but it
         * needs to be updated anyway...
         *
         * @param {string} avatarSrc location of new avatar image (absolute URL)
         * @private
         */
        _updateImageInProfileHeader: function(avatarSrc) {
            jQuery('.aui-page-header .aui-avatar-large img').attr('src', avatarSrc);
            jQuery('.aui-header .aui-avatar-small img').attr('src', avatarSrc);
        }
    });
});

AJS.namespace('JIRA.UserProfile.ProfileDetails', null, require('jira/user-profile-plugin/profile-details'));
