AJS.test.require(["com.atlassian.jira.jira-user-profile-plugin:user-details-resources"],function(){var b=require("jquery");var a=require("underscore");module("JIRA.UserProfile.ProfileDetails",{setup:function(){this.fixture=b("#qunit-fixture");this.initProfilePage({baseUrl:"http://myhost",});this.ProfileDetails=require("jira/user-profile-plugin/profile-details")},initProfilePage:function(c){this.fixture.empty();this.defaultBaseUrl=c.baseUrl;this.avatarSrc=(c.avatarSrc)?c.avatarSrc:c.baseUrl+"/avatar.jpg";this.createUserProfileHeader();this.createDetailsFragment()},createUserProfileHeader:function(){this.profileHeader=b('<div class="aui-page-header"></div>').appendTo(this.fixture);this.headerAvatarContainer=b('<div class="aui-avatar-large"></div>').appendTo(this.profileHeader);this.headerAvatarImg=b(AJS.format('<img src="{0}"/>',this.avatarSrc)).appendTo(this.headerAvatarContainer)},createDetailsFragment:function(){this.detailsFragment=b("<div></div>").appendTo(this.fixture);this.detailsAvatarImg=b(AJS.format('<img class="avatar-image" src="{0}"/>',this.avatarSrc)).appendTo(this.detailsFragment);this.lozengeContainer=b('<div class="gravatar-lozenge-container"></div>').appendTo(this.detailsFragment)},createProfileDetails:function(c){return new this.ProfileDetails(a.defaults({},c,{el:this.fixture,baseUrl:this.defaultBaseUrl}))}});test("ProfileDetails updates avatar in profile header after avatar change",function(){var c=this.createProfileDetails();var d="http://bogus/avatar";c.onAvatarChanged(d);equal(this.headerAvatarImg.attr("src"),d,"view should update avatar in page header")});test("ProfileDetails shows gravatar lozenge for external avatars on DOMReady",function(){this.initProfilePage({avatarSrc:"http://www.gravatar.com/avatar/00000000000000000000000000000000"});var c=this.createProfileDetails();var d=this.lozengeContainer.find(".aui-lozenge");equal(d.length,1,"should show a lozenge");equal(d.text(),"Gravatar",'lozenge should say "Gravatar"')});test("ProfileDetails handles http URL with port in it",function(){var d=this.defaultBaseUrl+":80";this.initProfilePage({baseUrl:d});var c=this.lozengeContainer.find(".aui-lozenge");equal(c.length,0,"should not show lozenge for baseUrl: "+d)});test("ProfileDetails handles https URL with port in it",function(){var d="https://the_host:443";this.initProfilePage({baseUrl:d});var c=this.lozengeContainer.find(".aui-lozenge");equal(c.length,0,"should not show lozenge for baseUrl: "+d)});test("ProfileDetails does not show gravatar lozenge for internal avatars on DOMReady",function(){this.createProfileDetails();var c=this.lozengeContainer.find(".aui-lozenge");equal(c.length,0,"should not show a lozenge")});test("ProfileDetails shows gravatar lozenge on changing from internal avatar to external",function(){var c=this.createProfileDetails();equal(this.lozengeContainer.find(".aui-lozenge").length,0,"initially there should be no lozenge");c.onAvatarChanged("http://www.gravatar.com/avatar/00000000000000000000000000000000");var d=this.lozengeContainer.find(".aui-lozenge");equal(d.length,1,"should show a lozenge");equal(d.text(),"Gravatar",'lozenge should say "Gravatar"')});test("ProfileDetails hides gravatar lozenge on changing from gravatar to internal",function(){var e="http://otherhost";this.initProfilePage({avatarSrc:"http://www.gravatar.com/avatar/00000000000000000000000000000000"});var c=this.createProfileDetails();equal(this.lozengeContainer.find(".aui-lozenge").length,1,"initially there should be a lozenge");c.onAvatarChanged(e+"/newimage.jpg");var d=this.lozengeContainer.find(".aui-lozenge");equal(d.length,0,"should hide the lozenge")});test("ProfileDetails updates avatar in profile header after avatar change to a relative URL",function(){var c=this.createProfileDetails();var d="/jira/secutre/someavatar";c.onAvatarChanged(d);equal(this.headerAvatarImg.attr("src"),d,"view should update avatar in page header");var e=this.lozengeContainer.find(".aui-lozenge");equal(e.length,0,"should not show a lozenge")});test("ProfileDetails removes gravatar lozenge on changing from external avatar to relative internal",function(){var c=this.createProfileDetails();equal(this.lozengeContainer.find(".aui-lozenge").length,0,"initially there should be no lozenge");c.onAvatarChanged("http://www.gravatar.com/avatar/00000000000000000000000000000000");var e=this.lozengeContainer.find(".aui-lozenge");equal(e.length,1,"should show a lozenge while pointing to an external avatar");equal(e.text(),"Gravatar",'lozenge should say "Gravatar"');c.onAvatarChanged("/jira/secutre/someavatar");var d=this.lozengeContainer.find(".aui-lozenge");equal(d.length,0,"should not show a lozenge after changing to a relative url")});test("ProfileDetails removes gravatar lozenge on changing from external avatar to absolute internal",function(){var f=this.defaultBaseUrl;var c=this.createProfileDetails();equal(this.lozengeContainer.find(".aui-lozenge").length,0,"initially there should be no lozenge");c.onAvatarChanged("http://www.gravatar.com/avatar/00000000000000000000000000000000");var e=this.lozengeContainer.find(".aui-lozenge");equal(e.length,1,"should show a lozenge while pointing to an external avatar");equal(e.text(),"Gravatar",'lozenge should say "Gravatar"');c.onAvatarChanged(f+"/newimage.jpg");var d=this.lozengeContainer.find(".aui-lozenge");equal(d.length,0,"should not show a lozenge after changing to a relative url")})});