require([
    'jira/user-profile-plugin/profile-details',
    'atlassian/libs/underscore-1.5.2',
    'jquery'
], function (
    ProfileDetails,
    _,
    jQuery
) {
    jQuery(function(){
        // bind the view to the pre-rendered profile details
        var views = [];
        jQuery('#details-profile-fragment').each(function() {
            views.push(new ProfileDetails({ el: this }));
        });

        // creates the user avatar picker, binding it to the views created above
        JIRA.createUserAvatarPickerDialog({
            trigger: "#details-user-avatar-trigger",
            username: jQuery("#avatar-owner-id").text(),
            defaultAvatarId: jQuery("#default-avatar-id").text(),
            select: function onAvatarSelected(avatar, avatarSrc) {
                _.each(views, function(view) {
                    view.onAvatarChanged && view.onAvatarChanged(avatarSrc);
                });
            }
        });
    });
});

