require(['jquery', 'jira/util/formatter', 'jira-help-tips/feature/help-tip'], function ($, formatter, HelpTip) {
    'use strict';

    $(function () {
        // help tip for retention period
        var $actionsButton = $("#auditing-actions-button");
        var helpTipContent = $actionsButton.data("retention-period-help-tip");

        if (helpTipContent) {
            var helpTip = new HelpTip({
                title: formatter.I18n.getText("jap.retention.period.help.tip.title"),
                bodyHtml: helpTipContent,
                anchor: $actionsButton,
                inlineDialogOpts: {
                    offsetY: 18,
                    width: 400
                }
            });

            helpTip.show();

            $actionsButton.on("click", function () {
                helpTip.dismiss();
            });
        }
    });
});