define('jira/auditing/settings-dialog', ['jira/auditing/templates', 'jira/dialog/form-dialog', 'jira/message', 'jquery'], function (AuditingTemplates, FormDialog, Messages, $) {
    'use strict';

    return FormDialog.extend({
        _handleSubmitResponse: function _handleSubmitResponse(data, xhr) {
            //data, xhr, smartAjaxResult
            if (this.serverIsDone) {
                if (this._hasStateChanged($("#auditing-hide-external-directories"))) {
                    this.collection.search();
                }

                if (this.options.autoClose) {
                    this.hide();
                }

                var textMessage = xhr.getResponseHeader("X-Atlassian-Dialog-Msg-Html");
                if (textMessage) {
                    var message = AuditingTemplates.settingsGlobalMessage({
                        message: textMessage
                    });

                    Messages.showInfoMsg(message, {
                        closeable: true
                    });
                }
            }
        },
        _hasStateChanged: function _hasStateChanged($hideExternalDirectories) {
            return $hideExternalDirectories.parent().attr("data-initial-state") === "true" !== ($hideExternalDirectories.attr("checked") === "checked");
        },
        init: function init(options) {
            this._super(options);
            this.collection = options.collection;

            this.onContentReady(function () {
                var $form = this.get$popup().find("#auditing-settings-form");
                var $select = $form.find("#auditing-retention-period");
                var $message = $form.find("#auditing-retention-period-warning");

                var translations = $form.data("retention-period-warning-translations");
                var currentPeriodValue = $form.data("current-period-value");

                var isShorterThan = function isShorterThan(compared, steady) {
                    if (-1 === compared) {
                        return false;
                    }
                    if (-1 === steady) {
                        return true;
                    }

                    return compared < steady;
                };

                $select.on("change", function () {
                    var newPeriodValue = $select.val();

                    if (isShorterThan(newPeriodValue, currentPeriodValue)) {
                        $message.find("p:not(.title)").html(translations[newPeriodValue]);
                        $message.removeClass("hidden");
                    } else {
                        $message.addClass("hidden");
                    }
                });
            });
        },
        // the overridden method below fixes JDEV-27994; JIRA.FormDialog detects if there are any messages
        // and show them on the next page reload; we don't need this behavior as we are handling the message on our
        // own and provide just one message header instead of required four - lacking header was the original cause
        // for this bug
        _detectMsgInstructions: function _detectMsgInstructions() {
            return null;
        }
    });
});

define('jira/auditing/settings-dialog-factory', ['jira/auditing/settings-dialog', 'jira/dialog/dialog-util'], function (AuditingSettingsDialog, DialogUtil) {
    'use strict';

    return function (collection) {
        return new AuditingSettingsDialog({
            autoClose: true,
            id: "auditing-settings-dialog",
            ajaxOptions: DialogUtil.getDefaultAjaxOptions,
            trigger: "#auditing-settings-dialog-trigger",
            collection: collection
        });
    };
});

AJS.namespace('JIRA.Auditing.createSettingsDialog', null, require('jira/auditing/settings-dialog-factory'));