define('jira/auditing/router', ['jira/auditing/router-helper', 'backbone', 'underscore'], function (RouterHelper, Backbone, _) {
    'use strict';

    return Backbone.Router.extend({
        _isInitialRoute: true,
        _homeParams: undefined,
        routes: {
            '': 'home',
            '*notFound': 'catchAll'
        },
        initialize: function initialize(options) {
            this.collection = options.collection;
            this.mainView = options.mainView;

            this.addEventListeners();
        },

        addEventListeners: function addEventListeners() {
            this.collection.on("sync", this.saveHistoryState, this);
        },
        home: function home() {
            this._isInitialRoute = false;

            // first time here - just save the current parameters
            if (typeof this._homeParams === "undefined") {
                this._homeParams = this.collection.getCurrentParams();
                this.mainView.render();
            } else {
                this.collection.setCurrentParams(this._homeParams);
                this.collection.pager();
            }
        },

        catchAll: function catchAll(string) {
            if (!string) {
                return;
            }
            var options = _.object(_.compact(string.split('/').map(function (urlPart) {
                var regex = /\?*(\S+):(.*)/;
                var split = urlPart.match(regex);

                if (split) {
                    split = [split[1], -1 === split[2].search(',') ? split[2] : split[2].split(',')];
                }
                return split;
            })));

            this.search(RouterHelper.assureParamsConsistency(options));
        },

        search: function search(options) {
            var params = _.defaults(options, {
                currentPage: 1
            });

            var initial = this._isInitialRoute;
            this._isInitialRoute = false;

            if (this.collection.hasExactParams(params)) {
                // collection is already populated exactly as it should be

                this.collection.ensurePageAvailable();
                this.mainView.render();
                // initial means the route has been triggered by Backbone.history
            } else {
                if (initial) {
                    // if not, url contained / contains hash, and additional request is needed for
                    // collection to have records consistent with its params

                    this.mainView.renderWithThrobber();
                    this.collection.isInitialRequest = true;
                }

                this.collection.setCurrentParams(params);
                this.collection.pager();
            }
        },
        saveHistoryState: function saveHistoryState() {
            var params = this.collection.getCurrentParams();
            var url = '';
            // @TODO: the mechanism here to recognize when the url should be replaced instead of being added should be more generic
            var replace = !!(this.collection.isRefreshing && !this.collection.topIdBeforeRefresh || this.collection._ensuringPageAvailable);

            // check if current params are the same like homepage ones; if so, this means
            // we are on the homepage
            if (!_.isEqual(this._homeParams, params)) {
                url = RouterHelper.generateUrl(this.collection.getCurrentParams());
            }

            this.navigate(url, { replace: replace });

            this.collection.isRefreshing = false;
            this.collection._ensuringPageAvailable = false;

            return this;
        }
    });
});