var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

define('jira/auditing/router-helper', ['underscore'], function (_) {
    'use strict';

    // object Key - a literal appearing in properly formatted url
    // collectionKey - a name of the key used to store param in collection
    // requiresCollectionKey - if present, current fragment will appear only if the collection has non-empty required param

    var urlParams = {
        search: { collectionKey: 'filter' },
        date: { collectionKey: 'date' },
        projects: { collectionKey: 'projectIds' },
        authors: { collectionKey: 'userIds' },
        page: { collectionKey: 'currentPage', type: 'number' },
        tid: { collectionKey: 'topId' }
    };

    return {
        urlParams: urlParams,
        // generate properly formatted auditing url
        generateUrl: function generateUrl(params) {
            params = params || {};
            var url = '';

            _.each(urlParams, function (obj, key) {
                var value = params[obj.collectionKey];
                var keyRequired = obj.requiresCollectionKey;

                if (!value || keyRequired && !params[keyRequired]) {
                    return;
                }

                if (!_.isArray(value)) {
                    value = [value];
                }

                if (value.length) {
                    url += '/' + key + ':' + value.map(function (val) {
                        return encodeURIComponent(val);
                    }).join(',');
                }
            });

            return url;
        },

        // get params out of query string
        parseQueryParams: function parseQueryParams() {
            var query = location.search.indexOf('?all=') === 0 ? location.search.substring(5) : location.search;
            var params = {};

            if (!query.length) {
                return params;
            }

            _.each(query.split('/'), function (pair) {
                var data = pair.split(':');
                if (data[1]) {
                    params[data[0]] = data[1].split(',');
                } else {
                    params[data[0]] = '';
                }
            });

            return params;
        },

        assureParamsConsistency: function assureParamsConsistency(data) {

            _.each(data, function (value, key, list) {
                var p = urlParams[key];

                if (p) {
                    if (p.type && p.type !== (typeof value === 'undefined' ? 'undefined' : _typeof(value))) {
                        value = this.assureParamType(value, p.type);
                    }
                    if (key !== p.collectionKey) {
                        list[p.collectionKey] = value;
                        delete list[key];
                    }
                }
            }.bind(this));

            return data;
        },
        assureParamType: function assureParamType(param, type) {
            switch (type) {
                case 'number':
                    param = parseInt(param, 10);
                    break;
            }

            return param;
        }
    };
});

AJS.namespace('JIRA.Auditing.RouterHelper', null, require('jira/auditing/router-helper'));