define('jira/auditing/records-pages-view', ['jira/auditing/records-view', 'jira/auditing/pagination-view', 'jira/util/formatter', 'jira/util/logger', 'jira/auditing/templates', 'backbone'], function (RecordsView, PaginationView, formatter, logger, Templates, Backbone) {
    'use strict';

    return Backbone.View.extend({

        el: ".auditing-pages",

        templates: {
            page: Templates.page,
            noResults: Templates.noResults,
            throbber: Templates.throbber
        },

        paginators: {
            top: null,
            bottom: null
        },

        initialize: function initialize() {
            this.collection.on('sync', function () {
                this.collection.isInitialRequest = false;this.disablePending();this.clean();this.render();
            }, this);
            this.collection.on('error', function () {
                this.collection.isInitialRequest = false;this.clean();this.render();this.clean();
            }, this);
            this.collection.on('request', function () {
                if (!this.collection.isInitialRequest) {
                    this.enablePending();
                }
                this.clean();
            }, this);
        },

        enablePending: function enablePending() {
            this.$(".auditing-pages-overlay").removeClass("hidden");
        },

        disablePending: function disablePending() {
            this.$(".auditing-pages-overlay").addClass("hidden");
        },

        clean: function clean() {
            if (this.paginators.top != null) {
                this.paginators.top.stop();this.paginators.top = null;
            }
            if (this.paginators.bottom != null) {
                this.paginators.bottom.stop();this.paginators.bottom = null;
            }
        },

        render: function render() {
            this.$el.html(this.templates.page());
            new RecordsView({ collection: this.collection });
            this.paginators.top = new PaginationView({ el: '.auditing-pagination.top', collection: this.collection });
            this.paginators.bottom = new PaginationView({ el: '.auditing-pagination.bottom', collection: this.collection });
            if (this.collection.empty) {
                this.$('.auditing-message').html(this.templates.noResults({
                    message: formatter.I18n.getText('jap.view.query.search.empty.message'),
                    hint: formatter.I18n.getText('jap.view.query.search.empty.hint')
                }));
            } else if (this.collection.size() === 0) {
                this.$('.auditing-message').html(this.templates.noResults({
                    message: formatter.I18n.getText('jap.view.query.search.noresults.message'),
                    hint: formatter.I18n.getText('jap.view.query.search.noresults.hint')
                }));
            }

            logger.trace("auditing.pages.view.render.complete");
        },

        renderWithThrobber: function renderWithThrobber() {
            this.$el.html(this.templates.page());
            new RecordsView({ collection: this.collection, emptyTable: true });
            this.$(".auditing-message").html(this.templates.throbber());
        }
    });
});

AJS.namespace('JIRA.Auditing.RecordsPagesView', null, require('jira/auditing/records-pages-view'));