define('jira/auditing/records-errors-view', ['backbone', 'jira/auditing/templates'], function (Backbone, Templates) {
    'use strict';

    return Backbone.View.extend({

        el: ".auditing-error",

        template: Templates.error,

        initialize: function initialize() {
            this.collection.on('request', function () {
                this.$el.html("");
            }, this);
            this.collection.on('sync', function () {
                this.$el.html("");
            }, this);
            this.collection.on('error', function () {
                this.$el.html(this.template());
            }, this);
        }
    });
});

AJS.namespace('JIRA.Auditing.RecordsErrorsView', null, require('jira/auditing/records-errors-view'));