define('jira/auditing/records-controller', ['jira/auditing/records-errors-view', 'jira/auditing/records-pages-view', 'jira/auditing/router', 'jira/auditing/router-helper', 'jira/auditing/records-analytics', 'jira/auditing/records', 'jira/auditing/settings-dialog-factory', 'jira/auditing/filter/collection', 'jira/auditing/filter/controller', 'jira/dialog/form-dialog', 'jira/analytics', 'wrm/context-path', 'backbone', 'jquery', 'underscore'], function (RecordsErrorsView, RecordsPagesView, Router, RouterHelper, RecordsAnalytics, Records, settingsDialogFactory, FiltersCollection, filterController, FormDialog, analytics, wrmContextPath, Backbone, $, _) {
    'use strict';

    return function () {

        return {
            analytics: undefined,
            collection: null,
            rootPath: wrmContextPath() + "/auditing/view",
            settingsDialog: null,
            timeFilter: null,

            filtersCollection: new FiltersCollection(),

            views: {},
            filters: {},

            init: function init() {
                if (!this.ensureCorrectPath()) {
                    return;
                }

                var $auditing = $(".auditing-view-records");

                this.collection = new Records(null, { filters: this.filtersCollection });

                this.collection.paginator_ui.perPage = $auditing.data("perpage");
                this.collection.reset($auditing.data("records"), { parse: true });
                this.collection.bootstrap();

                this.views['RecordsErrorsView'] = new RecordsErrorsView({ collection: this.collection });
                this.views['mainView'] = new RecordsPagesView({ collection: this.collection });

                // ::[ Filters ]::
                var $filterRoot = $('#filters');

                this.filters['filter'] = filterController({
                    views: { 'query': 'text' },
                    config: 'query'
                });

                this.filters['date'] = filterController({
                    type: 'dialog',
                    views: { 'date': 'date' },
                    config: 'date',
                    consts: $auditing.data("datepicker-params")
                });

                this.filters['userIds'] = filterController({
                    type: 'dropdown',
                    views: { 'author': 'checkbox' },
                    config: 'user'
                });

                this.filters['projectIds'] = filterController({
                    type: 'dropdown',
                    views: { 'project': 'checkbox' },
                    config: 'project'
                });

                $.each(this.filters, function (name, controller) {
                    controller.init({
                        collection: this.filtersCollection,
                        name: name,
                        $root: $filterRoot
                    });
                }.bind(this));

                this.collection.setCurrentParams($auditing.data("current-params"));
                this.collection.initializePulling();

                //do not block leaving auditing page
                window.onbeforeunload = function () {};

                this.analytics = new RecordsAnalytics();
                this.analytics.init(this.collection, this.filtersCollection);

                this.settingsDialog = settingsDialogFactory(this.collection);

                this.router = new Router({
                    collection: this.collection,
                    mainView: this.views.mainView,
                    filters: this.filtersCollection
                });

                new FormDialog({
                    id: "export-data-dialog",
                    trigger: "#auditing-export-data"
                });

                Backbone.history.start({
                    pushState: true,
                    root: this.rootPath,
                    silent: false
                });

                this.addEventLisneners();
            },

            addEventLisneners: function addEventLisneners() {
                this.collection.on("sync", this.collection.ensurePageAvailable, this.collection).on("auditing:update-records", this.updateRecords, this);

                this.filtersCollection.on('change:value', this.handleFilterChange, this);

                $('#filters').on('submit', this.handleFiltersFormSubmit);
                $("#auditing-export-data").on('click', function () {
                    analytics.send({ name: 'administration.auditing.view.export.clicked' });
                });

                return this;
            },

            handleFiltersFormSubmit: function handleFiltersFormSubmit(e) {
                e.preventDefault();
            },

            handleFilterChange: _.throttle(function (model, value, o) {
                if (!o.system) {
                    this.analytics.searchStarted();
                    this.collection.search();
                }
            }, 50, { leading: false }),

            // used to update collection with newer records that exists for current parameters - this is what user
            // literally see as a refresh
            updateRecords: function updateRecords() {
                this.collection.refresh();
            },

            // auditing view page should always be served from /auditing/view, to make client history / server rendering
            // fully working; however, there's no easy way for a webwork action to check if it's being served under it's name,
            // like ViewRecords.jspa, or under rewritten url. I believe this is somehow done in KA, so later it might
            // prove valuable to see how it's done there and implement this also in auditing (TODO candidate)
            ensureCorrectPath: function ensureCorrectPath() {
                var isAuditingPath = location.pathname.indexOf('auditing/view') !== -1;

                if (!isAuditingPath) {
                    location.replace(this.rootPath + RouterHelper.generateUrl(RouterHelper.assureParamsConsistency(RouterHelper.parseQueryParams())));
                }

                return isAuditingPath;
            }
        };
    };
});

AJS.namespace('JIRA.Auditing.RecordsController', null, require('jira/auditing/records-controller'));