define('jira/auditing/record', ['underscore', 'backbone'], function (_, Backbone) {
    'use strict';

    return Backbone.Model.extend({
        defaults: {
            summary: "",
            author: {
                fullName: ""
            },
            gmtOffset: "0",
            timezone: "",
            id: "",
            created: "",
            category: "",
            categoryId: "",
            remoteAddr: "",
            objectItem: {
                objectName: ""
            },
            eventSource: "",
            description: "",
            changedValues: [],
            associatedItems: []
        },
        parse: function parse(data) {
            if (!data.associatedItemsByType) {
                data.associatedItemsByType = _.groupBy(data.associatedItems, function (o) {
                    return o.objectType;
                });
            }
            return data;
        }
    });
});

AJS.namespace('JIRA.Auditing.Record', null, require('jira/auditing/record'));