/**
 * Views "Factory".
 * delivers available views
 */
define('jira/auditing/filter/views', ['jira/auditing/filter/view', 'jira/auditing/filter/textinput-view', 'jira/auditing/filter/singleselect-view', 'jira/auditing/filter/checkbox-multiselect-view', 'jira/auditing/filter/daterange-view', 'jira/auditing/filter/trigger-view', 'jira/auditing/filter/dropdown-view'], function (View, TextInputView, SingleSelectView, CheckboxMultiSelectView, DateRangeView, TriggerView, DropdownView) {
    'use strict';

    return {
        get: function get(variant, data) {
            var View;
            switch (variant) {
                case 'date':
                    View = DateRangeView;
                    break;
                case 'txt':
                case 'text':
                    View = TextInputView;
                    break;
                case 'single':
                case 'singleselect':
                    View = SingleSelectView;
                    break;
                case 'checkbox':
                    View = CheckboxMultiSelectView;
                    break;
                case 'trigger':
                    View = TriggerView;
                    break;
                case 'dropdown':
                    View = DropdownView;
                    break;
                default:
                    View = View;
                    break;
            }

            return new View(data);
        }
    };
});