/**
 * Generic Filter View
 */

define('jira/auditing/filter/view', ['underscore', 'backbone', 'jira/util/events/reasons', 'jira/util/events/types', 'jira/util/events'], function (_, Backbone, Reasons, Types, Events) {
    'use strict';

    return Backbone.View.extend({
        constructor: function constructor() {
            var prototype = this.constructor.prototype;

            while (prototype) {
                if (prototype.hasOwnProperty("events")) {
                    _.defaults(this.events, prototype.events);
                }
                if (prototype.hasOwnProperty("consts")) {
                    _.defaults(this.consts, prototype.consts);
                }
                prototype = prototype.constructor.__super__;
            }

            Backbone.View.apply(this, arguments);
        },

        $root: null,
        template: null,
        templateData: {},

        id: null,

        initialize: function initialize(options) {
            // our hook-up point
            this.$root = options.$root;
            this.template = options.template || this.template;
            this.templateData = _.extend({}, this.templateData, options.templateData);
            if (options.consts) {
                this.consts = _.extend({}, this.consts, options.consts);
            }

            this.i18n = options.i18n || this.i18n;

            this.id = options.id;

            this.model = options.model;

            // try to self-launch
            this.render();

            return this;
        },

        render: function render() {
            // be sure to have a template
            if (!this.template) {
                return this;
            }

            this.setElement(this.template(_.extend({}, this.templateData, this.model.toJSON())));

            this.appendToRoot();
            return this;
        },

        appendToRoot: function appendToRoot() {
            if (!this.$root || this.$root.jquery && !this.$root.length) {
                return this;
            }
            this.$root.append(this.el);

            // be kind and notify that we've modified the DOM
            Events.trigger(Types.NEW_CONTENT_ADDED, [this.$el, Reasons.contentRefreshed]);

            return this;
        }
    });
});