/**
 * Filter Trigger View
 * Generates a button that toggles on/off any subviews loaded into dropdown / inline dialog
 */
define('jira/auditing/filter/trigger-view', ['underscore', 'jira/auditing/filter/view', 'jira/auditing/templates'], function (_, View, Templates) {
    'use strict';

    return View.extend({
        template: Templates.Filters.trigger,

        consts: {
            MAX_VALUES: 2
        },

        initialize: function initialize() {
            View.prototype.initialize.apply(this, arguments);

            this.addEventListeners();
        },

        render: function render() {
            this.templateData = _.extend({}, this.templateData, this._getDisplayValue());

            View.prototype.render.apply(this, arguments);

            return this;
        },

        addEventListeners: function addEventListeners() {
            this.model.on('change:displayText', this.updateFilterDescription, this);

            return this;
        },

        // ::[ Event Handlers ]::

        updateFilterDescription: function updateFilterDescription() {
            var v = this._getDisplayValue();
            this.$el.text(v.text).attr('data-more-count', v.count ? '+' + v.count : '');

            return this;
        },

        // --------[ Private ]--------8<--------
        // hence it is Templates responsibility to define the behaviour of a component based upon received data
        // we want our fancy dropdown buttons to be limited to a particular length defined as:
        // - max this.consts.MAX_VALUES full option's descriptions
        // - AND not more than width defined in CSS
        _getDisplayValue: function _getDisplayValue() {
            var displayText = this.model.get('displayText');
            var moreCount;

            if (_.isArray(displayText)) {
                if (displayText.length > this.consts.MAX_VALUES) {
                    moreCount = displayText.length - this.consts.MAX_VALUES;
                }

                displayText = displayText.slice(0, this.consts.MAX_VALUES).join(', ');
            }

            displayText = displayText || this.i18n.defaultText;

            return {
                text: this.i18n.label(this.model.getCount(), displayText),
                count: moreCount
            };
        }

    });
});