/**
 * Textinput Filter View
 *
 * Attaches "live submit" events to any input.text within the template
 */
define('jira/auditing/filter/textinput-view', ['underscore', 'jira/auditing/filter/view', 'jira/auditing/templates'], function (_, View, Templates) {
    'use strict';

    return View.extend({
        template: Templates.Filters.genericInput,
        inputSync: null,

        consts: {
            'DEBOUNCE_DELAY': 300
        },

        events: {
            'input input.text': 'handleLiveChange',
            'change input.text': 'handleChange',
            'click .clear-field': 'handleClearField'
        },

        initialize: function initialize() {
            this.handleLiveChange = _.debounce(this.handleInputChange, this.consts.DEBOUNCE_DELAY);
            this.addEventListeners();
            return View.prototype.initialize.apply(this, arguments);
        },

        addEventListeners: function addEventListeners() {
            this.model.on('change:value', this.handleModelChange, this);
        },

        // ::[ Event Handlers ]::
        handleModelChange: function handleModelChange(model, value) {
            this.$('input').val(value);
            this.handleInputChange();
        },
        //we want to auto-submit changes in input field after user finishes input
        handleInputChange: function handleInputChange() {
            var $el = this.$('input');
            var empty = !$el.val();

            $el.toggleClass('with-value', !empty);
            $el.next('.aui-icon').toggleClass('noloading clear-field aui-iconfont-remove', !empty).toggleClass('aui-iconfont-search', empty);

            $el.trigger('change');
        },

        handleLiveChange: _.noop,

        handleClearField: function handleClearField() {
            this.model.unset('displayText').unset('value');
        },

        handleChange: function handleChange() {
            this.model.set({
                displayText: this.$('input').val(),
                value: this.$('input').val()
            });
            return this;
        }
    });
});