/**
 * Checkbox Multi Select Filter View
 * Extends SimpleSelect View
 *
 * Builds a nice multiselect with chcekboxes
 */

define('jira/auditing/filter/checkbox-multiselect-view', ['jira/auditing/filter/singleselect-view', 'jira/ajs/select/checkbox-multi-select', 'jira/auditing/picker/util', 'jira/auditing/templates'], function (SingleSelectView, CheckboxMultiSelect, AuditingPickerUtil, Templates) {
    'use strict';

    return SingleSelectView.extend({
        events: {
            'change input[type=checkbox]': 'handleSelection'
        },

        template: Templates.Filters.genericSelect,

        createUserPicker: function createUserPicker() {
            var $filter = this.$el.is(".js-filter-field") ? this.$el : this.$(".js-filter-field").first();

            if (!$filter.length || $filter.data("aui-ss")) {
                return this;
            }

            $filter
            // ID and multiple type is required by CheckboxMultiSelect
            .attr('multiple', true).attr('id', this.model.get('name') + '-js-field');

            this.filterComponent = new CheckboxMultiSelect({
                inputText: this.i18n.inputText,
                element: $filter,
                itemAttrDisplayed: "label",
                maxInlineResultsDisplayed: 5,
                content: "mixed",
                suggestionsHandler: AuditingPickerUtil.suggestionsHandler.CheckboxMultiSelect,
                ajaxOptions: this._getAjaxOptions()
            });

            return this;
        },

        addEventListeners: function addEventListeners() {
            this.model.on('change:initdata', this.handleInitDataLoad, this);
            return SingleSelectView.prototype.addEventListeners.apply(this, arguments);
        },

        // ::[ Event Handlers ]::
        handleDropdownHide: function handleDropdownHide() {
            this.filterComponent.clearQueryField();
        },

        handleInitDataLoad: function handleInitDataLoad(model, value) {
            if (!value) {
                return this;
            }

            var opt = this._getAjaxOptions();

            opt.formatResponse(value).items().forEach(function (item) {
                this.filterComponent.selectItem(item);
            }.bind(this));

            // update the interface
            this.handleSelection();
        }
    });
});