define('jira/auditing/picker/util', ['underscore', 'jira/ajs/list/item-descriptor', 'jira/ajs/list/group-descriptor', 'jira/ajs/select/suggestions/checkbox-multi-select-suggest-handler', 'jira/ajs/select/suggestions/suggest-helper'], function (_, ItemDescriptor, GroupDescriptor, CheckboxMultiSelectSuggestHandler, SuggestHelper) {
    'use strict';

    return {
        suggestionsHandler: {
            CheckboxMultiSelect: CheckboxMultiSelectSuggestHandler.extend({
                formatSuggestions: function formatSuggestions(groups, query) {

                    var selectedItems = SuggestHelper.removeDuplicates(this.model.getDisplayableSelectedDescriptors());
                    var selectedGroup = new GroupDescriptor({
                        styleClass: "selected-group",
                        items: selectedItems,
                        actionBarHtml: selectedItems.length > 1 && !query.length ? this.createClearAll() : null
                    });

                    if (query.length > 0) {
                        groups = _.flatten([SuggestHelper.removeSelected(groups, selectedItems), selectedGroup]);
                    } else {
                        groups = [selectedGroup];
                    }

                    return groups;
                }
            })
        },
        formatResponse: {
            // this is a near exact copy of jira/field/user-picker-util BUT extended by fieldText attribute
            // It probably would be wise to extend he original but hence we can't properly estimate the impact of
            // this action - we're playing a safe card here.
            user: function user(data) {
                // userPicker.formatResponse,
                var groupDescriptor = new GroupDescriptor({
                    weight: 1, // order or groups in suggestions dropdown
                    label: data.footer //empty
                });

                _.each(data.users, function (user) {
                    groupDescriptor.addItem(new ItemDescriptor({
                        value: user.key, // value of item added to select
                        fieldText: user.displayName, // the text displayed in field when this item is selected
                        label: user.displayName,
                        icon: user.avatarUrl,
                        allowDuplicate: false,
                        highlighted: true
                    }));
                });

                return groupDescriptor;
            },
            project: function project(data) {
                var groupDescriptor = new GroupDescriptor({
                    weight: 1, // order or groups in suggestions dropdown
                    label: data.footer //empty
                });

                _.each(data, function (project) {
                    groupDescriptor.addItem(new ItemDescriptor({
                        value: project.id, // value of item added to select
                        fieldText: project.key,
                        label: project.name + (project.key ? ' (' + project.key + ')' : ''), // title of lozenge
                        icon: project.avatarUrl || project.avatarUrls['48x48'],
                        allowDuplicate: false,
                        highlighted: false
                    }));
                });

                return groupDescriptor;
            }
        }
    };
});