/**
 * Models "Factory".
 * delivers available models
 */
define('jira/auditing/filter/models', ['jira/auditing/filter/model', 'jira/auditing/filter/daterange-model', 'jira/auditing/filter/select-model'], function (FilterModel, DateRangeModel, SelectModel) {
    'use strict';

    return {
        get: function get(data) {
            var Model;

            switch (data.name) {
                case 'date':
                    Model = DateRangeModel;
                    break;
                case 'userIds':
                case 'projectIds':
                    Model = SelectModel;
                    break;
                default:
                    Model = FilterModel;
            }

            return new Model(data);
        }
    };
});