/**
 * Select Filter model.
 * Stores all attribute values defined in filter.
 * allows to set init data for select components
 */
define('jira/auditing/filter/select-model', ['underscore', 'jira/auditing/filter/model'], function (_, Model) {
    'use strict';

    return Model.extend({
        idAttribute: 'name',

        setData: function setData(data) {
            if (_.isArray(data) && !data.length) {
                return this;
            }
            this.set({ initdata: data }, { system: true });
        }
    });
});