/**
 * Basic Filter model.
 * Stores all attribute values defined in filter.
 */
define('jira/auditing/filter/model', ['backbone', 'underscore'], function (Backbone, _) {
    'use strict';

    return Backbone.Model.extend({
        defaults: {
            displayText: null,
            value: null
        },

        idAttribute: 'name',

        setData: function setData(data) {
            var o = {};

            if (_.isArray(data)) {
                o.value = data.length ? data : null;
            } else if (_.isObject(data)) {
                o = data;
            } else {
                o.value = data;
            }

            // do not overwrite displayText iv value is already set
            if (o.value && !o.displayText && this.get('value') !== o.value) {
                o.displayText = o.value;
            }

            o.value = o.value || null;

            this.set(o, { system: true });

            return this;
        },

        getCount: function getCount() {
            var val = this.get('value');
            if (val) {
                val = _.isArray(val) ? val.length : 1;
            } else {
                val = 0;
            }
            return val;
        },

        hasValue: function hasValue() {
            var value = this.get('value');

            // empty array counts as empty value
            if (_.isArray(value)) {
                value = value.length;
            }

            return !!value;
        }
    });
});