/**
 * Daterange Filter model.
 * Stores all attribute values defined in filter.
 */
define('jira/auditing/filter/daterange-model', ['underscore', 'jira/auditing/filter/model', 'jira/util/logger'], function (_, Model, logger) {
    'use strict';

    return Model.extend({
        setData: function setData(data) {
            var o = {};
            var d;

            // do not overwrite displayText iv value is already set
            if (data) {
                if (_.isArray(data)) {
                    data = _.compact(data);

                    o.value = data;
                    d = data.sort().slice(0);
                    o.dateTo = parseInt(d.pop()) || null;
                    o.dateFrom = parseInt(d.pop()) || null;
                } else {
                    o.value = data;
                    o.dateTo = parseInt(data) || null;
                }
            } else {
                o.value = null;
                o.dateTo = null;
                o.dateFrom = null;
            }

            this.set(o, { system: true });
        },

        setDate: function setDate(what, value) {
            switch (what) {
                case 'dateFrom':
                    this._handleDateFromChange(value);
                    break;
                case 'dateTo':
                    this._handleDateToChange(value);
                    break;
            }
            return this;
        },

        // --------[ Private ]--------8<--------
        // validates From date entry
        _handleDateFromChange: function _handleDateFromChange(value) {
            value = new Date(value).setSeconds(0, 0);

            var tonight = new Date().setHours(23, 59, 59, 999);
            var dTo = this.get('dateTo');

            if (value) {
                if (value > tonight) {
                    this.trigger('error', 'future:start');
                }

                if (!dTo) {
                    this.set('dateTo', tonight);
                    dTo = tonight;
                }

                if (value > dTo) {
                    this.set('dateFrom', new Date(dTo).setHours(0, 0, 0, 0)).trigger('error', 'bigger:start');
                } else {
                    this.set('dateFrom', value);
                }
            } else {
                this.unset('dateFrom');
            }

            this._updateValue();
            logger.trace("auditing.filters.date.from.set");
        },

        // validates To date entry
        _handleDateToChange: function _handleDateToChange(value) {
            value = new Date(value).setSeconds(59, 999);

            var tonight = new Date().setHours(23, 59, 59, 999);
            var dFrom = this.get('dateFrom');

            if (value) {
                if (value > tonight) {
                    value = tonight;
                    this.trigger('error', 'future:end');
                }

                if (value < dFrom) {
                    this.set('dateFrom', new Date(value).setHours(0, 0, 0, 0)).trigger('error', 'bigger:start');
                }

                this.set('dateTo', value);
            } else {
                this.unset('dateFrom').unset('dateTo');
            }

            this._updateValue();

            logger.trace("auditing.filters.date.to.set");
        },

        _updateValue: function _updateValue() {
            var val = _.compact([this.get('dateFrom'), this.get('dateTo')]);

            if (val.length) {
                this.set('value', val);
            } else {
                this.unset('value');
            }
        }
    });
});