/**
 * Have some of the search fields pre-configured
 */
define('jira/auditing/filter/pre-defined-config', ['jira/auditing/picker/util'], function (PickerUtil) {
    'use strict';

    return {
        'date': {
            templateData: {
                placeholderText: AJS.params.dateFormat
            }
        },
        'query': {
            templateData: {
                type: 'text',
                icon: 'search icon-default',
                extraClasses: 'with-icon'
            }
        },
        'user': {
            restAPIpath: '/rest/api/2/user/picker',
            restOptions: {
                formatResponse: PickerUtil.formatResponse.user
            },
            templateData: {
                isMultiple: false,
                isAutofocus: true,
                options: []
            }
        },
        'project': {
            restAPIpath: '/rest/api/2/project',
            restOptions: {
                query: false,
                removeOnUnSelect: false,
                formatResponse: PickerUtil.formatResponse.project
            },
            templateData: {
                isMultiple: true,
                isAutofocus: true,
                options: []
            }
        },
        get: function get(id) {
            return this[id] || {};
        }
    };
});