define('jira/auditing/filter/i18n', ['underscore', 'jira/util/formatter'], function (_, formatter) {
    'use strict';

    return {
        'common': {
            'trigger': {
                'defaultText': formatter.I18n.getText('common.words.all'),
                'label': function label(count, msg) {
                    return formatter.I18n.getText('jap.filter.button.message', count, msg);
                }
            }
        },
        'query': {
            'placeholder': formatter.I18n.getText('jap.view.query.search.placeholder'),
            'description': formatter.I18n.getText('jap.view.query.search.description')
        },
        'date': {
            'trigger': {
                'label': function label(count, msg) {
                    return formatter.I18n.getText('jap.date.button.message', msg);
                }
            },
            'to': function to(from, _to) {
                return formatter.I18n.getText('jap.date.filter.to.dates', from, _to);
            },
            'error': {
                'bigger:start': formatter.I18n.getText('jap.time.filter.dates.bigger.error'),
                'future': formatter.I18n.getText('jap.time.filter.dates.future.error')
            }
        },
        'userIds': {
            'trigger': {
                'defaultText': formatter.I18n.getText('common.words.all'),
                'label': function label(count, msg) {
                    return formatter.I18n.getText('jap.user.filter.button.message', count, msg);
                }
            }
        },
        'projectIds': {
            'trigger': {
                'label': function label(count, msg) {
                    return formatter.I18n.getText('jap.project.filter.button.message', count, msg);
                }
            }
        },

        get: function get(path, withCommon) {
            var ret;

            if (_.isString(path)) {
                path = path.split('.');
            }

            if (_.isArray(path)) {
                ret = path.reduce(function (o, key_part) {
                    return o[key_part] || {};
                }, this);
            }

            if (withCommon) {
                path.splice(0, 1, 'common');
                ret = _.extend({}, this.get(path), ret);
            }

            return ret;
        }
    };
});