/**
 * Generic Filter Controller
 * Generates new Filter model, gathers all needed information and inits all subviews
 */

define('jira/auditing/filter/controller', ['underscore', 'jira/auditing/filter/pre-defined-config', 'jira/auditing/filter/i18n', 'jira/auditing/filter/models', 'jira/auditing/filter/views'], function (_, preDefinedConfig, i18n, Models, Views) {
    'use strict';

    return function (opt) {
        return {
            model: null,
            collection: null,

            // options passed before init
            opt: opt,

            // subviews
            views: {},

            name: null,

            init: function init(options) {
                // be sure to have a name.
                this.name = options.name || _.uniqueId('ftr_');

                this.collection = options.collection;
                this.model = Models.get({
                    name: this.name
                });

                this.collection.add(this.model);

                this.opt = _.extend({}, this.opt, options);

                this.initViews();

                return this;
            },

            // ::[ INIT Views ]::
            initViews: function initViews() {
                var $root = this.opt.$root;

                // if we want to build a 'dropdown' filter AKA press-a-button-to-see-options
                if (_.contains(['dropdown', 'dialog', 'inlinedialog'], this.opt.type)) {
                    this.views['trigger'] = Views.get('trigger', {
                        model: this.model,
                        $root: this.opt.$root,
                        i18n: i18n.get([this.name, 'trigger'], true),
                        templateData: {
                            extraClasses: this.name,
                            type: this.opt.type
                        }
                    });

                    this.views['dropdown'] = Views.get('dropdown', {
                        model: this.model,
                        $root: this.opt.$root,
                        templateData: {
                            type: this.opt.type
                        }
                    });

                    // we want to load all subviews into our dropdown layer
                    $root = this.views['dropdown'].$('form');

                    this._addDropdownEvents();
                }

                // are there any actual views defined?
                _.each(this.opt.views, function (view, name) {
                    this.views[name] = Views.get(view, _.extend({
                        model: this.model,
                        $root: $root,
                        i18n: i18n.get(this.name),
                        consts: this.opt.consts
                    },
                    // maybe we have some pre-defined settings?
                    preDefinedConfig.get(this.opt.config)));
                }.bind(this));

                return this;
            },

            // --------[ Private ]--------8<--------

            _addDropdownEvents: function _addDropdownEvents() {
                // propagate dropdown event to all views
                this.views['dropdown'].$el.on('aui-dropdown2-show aui-show', this._handleDropdownShow.bind(this)).on('aui-dropdown2-hide aui-hide', this._handleDropdownHide.bind(this));
            },
            _handleDropdownShow: function _handleDropdownShow() {
                _.each(this.views, function (view) {
                    view.trigger('aui-dropdown2-show');
                });
            },
            _handleDropdownHide: function _handleDropdownHide() {
                _.each(this.views, function (view) {
                    view.trigger('aui-dropdown2-hide');
                });
            }
        };
    };
});