/**
 * Filters' Collection
 * Contains all active filters.
 * Acts as access point for other parts of the system when querying for set filters
 */
define('jira/auditing/filter/collection', ['backbone', 'underscore', 'jira/auditing/filter/model'], function (Backbone, _, FilterModel) {
    'use strict';

    return Backbone.Collection.extend({
        model: FilterModel,

        setFilters: function setFilters(data) {
            this.each(function (model) {
                model.setData(data[model.id]);
            });
        },
        getAllSet: function getAllSet() {
            return this.reject(function (model) {
                return !model.hasValue();
            });
        },
        getAllValues: function getAllValues() {
            // return a object representing all non-empty filter values
            return _.object(this.getAllSet().map(function (model) {
                return [model.get('name'), model.get('value')];
            }));
        }
    });
});