define('jira/auditing/session-timed-out-dialog', ['jquery', 'jira/auditing/templates', 'jira/dialog/form-dialog', 'jira/util/data/meta', 'wrm/context-path'], function ($, Templates, FormDialog, Meta, wrmContextPath) {
    'use strict';

    return {

        dialogHasShown: false,

        whiteList: ["/rest/jira-auditing-plugin/1/view", "/rest/api/latest/auditing/settings"],

        onRequestResponse: function onRequestResponse(e, resp, opts) {

            if (!this.dialogHasShown && this.urlIsInWhiteList(opts.url)) {
                var currentUserName = this.loggedInUserName();
                var responseUserName = resp.getResponseHeader("X-AUSERNAME");

                if (this.userHasChanged(currentUserName, responseUserName)) {
                    this.dialogHasShown = true;
                    var dialog = new FormDialog({
                        content: $(Templates.anonymousErrorDialog({
                            redirect: window.location.href.substring(window.location.href.indexOf(wrmContextPath()) + wrmContextPath().length)
                        }))
                    });
                    dialog.show();
                }
            }
        },

        userHasChanged: function userHasChanged(currentUserName, responseUserName) {
            // User is anonymous and page has loaded in that state
            // Or possibly the user logged in and out elsewhere ~ however this is a bit edgecasey.
            if (currentUserName === "" && responseUserName === "anonymous") {
                return false;
            }

            // User loaded the page as anonymous and logged in elsewhere
            if (currentUserName === "" && responseUserName && responseUserName !== "anonymous" && responseUserName !== "") {
                return false;
            }

            // User was previously logged in and now their username is now anonymous (session timed out).
            if (currentUserName !== "" && responseUserName === "anonymous") {
                return true;
            }

            return false;
        },

        urlIsInWhiteList: function urlIsInWhiteList(url) {
            for (var i = 0; i < this.whiteList.length; i++) {
                var whiteListUrl = this.whiteList[i];
                if (url.indexOf(whiteListUrl) > -1) {
                    return true;
                }
            }

            return false;
        },

        /**
         * Returns the name of the currently logged in user
         */
        loggedInUserName: function loggedInUserName() {
            return Meta.get('remote-user');
        }
    };
});

AJS.namespace('JIRA.Auditing.SessionTimedOutDialog', null, require('jira/auditing/session-timed-out-dialog'));