define("jira/projects/util/browser", function(
) {
    "use strict";

    return {
        getCurrentUrl: function() {
            return document.location.href;
        },

        getCurrentLocation: function() {
            return document.location;
        },

        hasPushState: function() {
            return !!(window.history && window.history.pushState);
        },

        locationReplace: function(url) {
            return window.location.replace(url);
        },

        locationAssign: function(url) {
            return window.location.assign(url);
        },

        locationReload: function(forceGet) {
            window.location.reload(forceGet);
        },

        hasLocalStorage: function() {
            try {
                return 'localStorage' in window && window.localStorage !== null;
            } catch (e) {
                return false;
            }
        }
    };
});

AJS.namespace("JIRA.Projects.Util.Browser", null, require("jira/projects/util/browser"));
