define('jira/projects/components/subnavigator/entities/items', ["underscore", "backbone"], function(_, Backbone) {
    return Backbone.Model.extend({
        defaults: {
            itemGroups: [],
            selectedItem: null
        },

        isEmpty: function() {
            return _.isEmpty(this.getAllItems());
        },

        selectItem: function(itemId) {
            var items = this.getAllItems();
            this.set("selectedItem",  _.find(items, function(item) { return item.id === itemId; }) || _.first(items));
        },

        getAllItems: function() {
            return _.flatten(this.get("itemGroups"));
        }
    });
});
