define("jira/projects/components/pinnable-navigator/views/navigator-view/unpinned-view", [
    "jira/projects/components/pinnable-navigator/templates",
    "jira/projects/components/pinnable-navigator/views/navigator-view/navigator-view",
    "jira/projects/components/pinnable-navigator/views/list-view/unpinned-list-view"
], function(Templates, NavigatorView, UnpinnedListView) {
    "use strict";

    return NavigatorView.extend({
        template: Templates.unpinned,

        initialize: function() {
            this.listItemsView = new UnpinnedListView({
                model: this.options.model,
                id: this.options.id || "",
                title: this.options.title,
                manageText: this.options.manageText,
                manageLocation: this.options.manageLocation,
                emptyText: this.options.emptyText,
                tooltipTimeout: this.options.tooltipTimeout,
                searchView: this.options.searchView
            });

            this.listenTo(this.listItemsView, "itemSelected", function(data){
                this.trigger("itemSelected", data);
            });
        },
        //Add the list to this component
        putListintoView: function(){
            this.listItemsView.setElement(this.$(".js-unpinned-items-list"));
            this.renderList();
        }
    });
});
