AJS.test.require("com.atlassian.jira.jira-projects-plugin:pinnablenavigator-test", function() {
    "use strict";

    var jQuery = require("jquery");

    var Items = require("jira/projects/components/pinnable-navigator/entities/items");
    var Trigger = require("jira/projects/components/pinnable-navigator/views/trigger");

    var ITEM_1 = { id: "item1", label: "Item 1", description: "Item 1"};
    var ITEM_2 = { id: "item2", label: "Item 2", description: "Item 2" };
    var ITEMS = [{items: [ITEM_1]}, {items: [ITEM_2]}];

    var ID = "id";

    module("jira/projects/components/pinnable-navigator/views/trigger", {
        setup: function() {
            this.$el = jQuery("<div/>");
            this.model = new Items({itemGroups: ITEMS});
            this.view = new Trigger({
                el: this.$el,
                model: this.model,
                id: ID
            });
        }
    });

    test("Uses the label of the selected item to render the template", function() {
        this.model.selectItem(ITEM_2.id);

        var viewData = this.view.serializeData();

        equal(viewData.label, ITEM_2.label);
    });

    test("Uses the given id as a suffix when rendering the template", function() {
        this.model.set({itemGroups: [{items: [ITEM_1]}]});
        this.model.selectItem(ITEM_1.id);

        this.view.render();

        ok(this.$el.find("#subnav-trigger-" + ID).length === 1);
    });


    test("If no selected item, uses default", function() {
        this.model.set({itemGroups: []});

        this.view.render();

        equal(this.$el.find("#subnav-trigger-" + ID).text(), "project.subnavigator.manage.switch");
    });
});
