AJS.test.require("com.atlassian.jira.jira-projects-plugin:pinnablenavigator-test", function() {
    "use strict";

    var Deferred = require("jira/jquery/deferred");
    var jQuery = require("jquery");
    var _ = require("underscore");

    var Items = require("jira/projects/components/pinnable-navigator/entities/items");
    var Dialog = require("jira/projects/components/pinnable-navigator/manage-dialog/views/dialog");

    var ITEM_1 = {id: "item1", label: "Item 1", link: "http://www.atlassian.com"};
    var ITEM_2 = {id: "item2", label: "Item 2", link: "http://jira.atlassian.com", count:5};


    function createDialog (items, options) {
        var model = new Items({itemGroups: items});
        model.save = function () {
            var deferred = new Deferred();
            deferred.resolve();
            return deferred;
        };

        options = _.extend({model: model, title: "Reports"}, options);
        return new Dialog(options);
    }

    module("jira/projects/components/pinnable-navigator/manage-dialog/views/dialog", {
        defaultDialog: function () {
            var items = [{allowReorder: true, items: [ITEM_1]}, {allowReorder: true, items: [ITEM_2]}];
            return createDialog(items, {
                manageText: "Manage Dialog",
                emptyText: "Nothing here"
            });
        },
        dialogWithDefaultTitle: function(){
            var items = [{allowReorder: true, items: [ITEM_1]}, {allowReorder: true, items: [ITEM_2]}];
            return createDialog(items);
        },
        dialogWithDeleteOption: function(){
            var items = [{allowDelete: true, items: [ITEM_1]}, {allowDelete: true, items: [ITEM_2]}];
            return createDialog(items);
        },
        dialogWithReorderOption: function(){
            var items = [{allowReorder: true, items: [ITEM_1]}, {allowReorder: true, items: [ITEM_2]}];
            return createDialog(items);
        },
        dialogWithOneManagebleGroup: function(){
            var items = [{allowReorder: true, items: [ITEM_1]}, {items: [ITEM_2]}];
            return createDialog(items);
        }
    });

    test("The title is same as user input", function() {
        var view = this.defaultDialog();
        view.render();
        equal(jQuery.trim(view.$("h2.aui-dialog2-header-main").html()), "Manage Dialog");
    });

    test("The title is default if user don't input any title", function() {
        var view = this.dialogWithDefaultTitle();
        view.render();
        equal(jQuery.trim(view.$("h2.aui-dialog2-header-main").html()), "project.subnavigator.manage.button Reports");
    });

    test("The items list is rendered with given model", function() {
        var view = this.defaultDialog();
        view.render();
        equal(jQuery.trim(view.$("table tr").length), 2);
    });

    test("The items match with data in model", function() {
        var view = this.defaultDialog();
        view.render();
        var firstItem = view.$("table tr").eq(0);
        var secondItem = view.$("table tr").eq(1);

        equal(firstItem.find('td:first-child+td').text(), ITEM_1.label);
        equal(firstItem.find('td:first-child+td+td').text().length, 0);

        equal(secondItem.find('td:first-child+td').text(), ITEM_2.label);
        equal(secondItem.find('td:first-child+td+td').text(), ITEM_2.count);
    });

    test("Show/Hide the loading", function() {
        var view = this.defaultDialog();
        view.render();
        view.showLoading();

        equal(view.$('.js-manage-save-spinner .spinner').length, 1);
        view.stopLoading();

        equal(view.$('.js-manage-save-spinner .spinner').length, 0);
    });

    test("Clicking Delete button will delete item on view", function() {
        var view = this.dialogWithDeleteOption();
        view.render();
        var firstItem = view.$("table tr").eq(0);

        equal(view.$('table tr').length, 2);
        firstItem.find('button').click();
        equal(view.$('.js-deleted').length, 1);
    });

    test("Showing Delete buttons only when allowDelete: true", function() {
        var view = this.dialogWithDeleteOption();
        view.render();

        var deleteButtons = view.$(".js-manage-item-delete-button button");

        equal(deleteButtons.length, 2);

        equal(view.$(".js-sortable-items").length, 0);
    });

    test("Showing sort icons only when allowReorder: true", function() {
        var view = this.dialogWithReorderOption();
        view.render();

        var deleteButtons = view.$(".js-manage-item-delete-button button");

        equal(deleteButtons.length, 0);

        equal(view.$(".js-sortable-items").length, 2);
    });

    test("Showing empty message when all items are deleted", function() {
        var view = this.dialogWithDeleteOption();
        view.render();
        view.$("table tr button").click();
        equal(view.$(".js-empty").length, 1);
    });

    test("Only groups that are manageable show", function () {
        var view = this.dialogWithOneManagebleGroup();
        view.render();
        equal(view.$('table tr').length, 1);
    });
});
