AJS.test.require("com.atlassian.jira.jira-projects-plugin:pinnablenavigator-test", function() {
    "use strict";

    var Deferred = require("jira/jquery/deferred");
    var jQuery = require("jquery");

    var Items = require("jira/projects/components/pinnable-navigator/entities/items");
    var ManageDialog = require("jira/projects/components/pinnable-navigator/manage-dialog/manage-dialog");

    var ITEM_1 = {id: "item1", label: "Item 1", link: "http://www.atlassian.com"};
    var ITEM_2 = {id: "item2", label: "Item 2", link: "http://jira.atlassian.com", count:5};
    var ITEMS = [
        {
            id: "section1",
            allowDelete: true,
            items: [ITEM_1, ITEM_2]
        }
    ];

    module("jira/projects/components/pinnable-navigator/manage-dialog/manage-dialog", {
        setup: function() {
            this.model = new Items.create({itemGroups: ITEMS},{
                save: function() {
                    return new Deferred().resolve();
                }
            });
            this.manageDialogControl = ManageDialog.create({
                model: this.model,
                title: "Reports",
                manageText: "Manage",
                emptyText: "Nothing here"
            });
        },
        teardown: function() {
            this.manageDialogControl.dialog.$el.find('.aui-iconfont-close-dialog').click();
        }
    });

    test("Showing the manage dialog", function () {
        this.manageDialogControl.show();

        equal(this.manageDialogControl.dialog.$el.is(":visible"), true);

        this.manageDialogControl.dialog.$el.find('.aui-iconfont-close-dialog').click();

        equal(this.manageDialogControl.dialog.$el.is(":hidden"), true);
    });

    test("Prevent close this dialog when user clicks outside", function() {
        this.manageDialogControl.show();

        equal(this.manageDialogControl.dialog.$el.is(":visible"), true);

        jQuery('.aui-blanket').click();

        equal(this.manageDialogControl.dialog.$el.is(":visible"), true);
    });

    test("Stopping the spinner when the popup is closed", function () {

        var stopLoading = this.spy();
        this.manageDialogControl.show();

        this.manageDialogControl.listenTo(this.manageDialogControl.dialog,"hide",stopLoading);
        this.manageDialogControl.dialog.$el.find('.aui-iconfont-close-dialog').click();
        sinon.assert.calledOnce(stopLoading);
    });

    test("Saving new data into server", function () {
        this.manageDialogControl.show();

        var firstItem = this.manageDialogControl.options.manageDialogView.$el.find("table tr").eq(0);
        equal(firstItem.hasClass('js-deleted'), false);

        this.manageDialogControl.dialog.$el.find('.js-manage-item-delete-button button').eq(0).click();
        equal(firstItem.hasClass('js-deleted'), true);

        this.manageDialogControl.dialog.$el.find('.js-manage-save-button').click();

        ok(!this.model.getItemById("item1"), "expected item1 to be deleted");

    });
});


