AJS.test.require("com.atlassian.jira.jira-projects-plugin:pinnablenavigator-test",function(){var h=require("underscore");var g=require("backbone");var c=require("jira/projects/components/pinnable-navigator/entities/items");var f={id:"item1",label:"Item 1"};var e={id:"item2",label:"Item 2"};var d={id:"item3",label:"Item 3"};var b=[{items:[f],id:"group1"},{items:[e],id:"group2"}];var i=[{items:[f]},{items:[e]},{items:[d],type:"buttons"}];function a(){return h.extend({},g.Events)}module("jira/projects/components/pinnable-navigator/entities/items",{setup:function(){this.model=new c({})}});test("Is empty when given list of items is undefined",function(){this.model.set("itemGroups",undefined);strictEqual(this.model.isEmpty(),true)});test("Is empty when given list of items is empty",function(){this.model.set("itemGroups",[]);strictEqual(this.model.isEmpty(),true)});test("Is not empty when the list of items contains something",function(){this.model.set("itemGroups",["item1"]);strictEqual(this.model.isEmpty(),false)});test("Keeps a reference to the selected item when there is one with the given id",function(){this.model.set("itemGroups",b);this.model.selectItem(e.id);equal(this.model.get("selectedItem"),e)});test("Sets the selected item to the first one if there is no item with the given id",function(){this.model.set("itemGroups",b);this.model.selectItem("nonexistentItem");equal(this.model.get("selectedItem"),f)});test("Sets the selected item to undefined if there is no item with the given id and the list of items is empty",function(){this.model.set("itemGroups",[]);this.model.selectItem(f.id);equal(this.model.get("selectedItem"),undefined)});test("Sets the selected item to undefined if there is no item with the given id and the list of items is undefined",function(){this.model.set("itemGroups",undefined);this.model.selectItem(f.id);equal(this.model.get("selectedItem"),undefined)});test("Triggers a 'change:selectedItem' event when an item is selected",function(){var j=this.spy();a().listenTo(this.model,"change:selectedItem",j);this.model.set("itemGroups",b);this.model.selectItem(e.id);sinon.assert.calledOnce(j)});test("Returns a flat version of the items list when asked for all items",function(){this.model.set("itemGroups",b);var j=this.model.getAllItems();deepEqual(j,[f,e])});test("Returns all real items (except buttons such as New Queue or New Report)",function(){this.model.set("itemGroups",i);var j=this.model.getAllItemsExceptButtons();deepEqual(j,[f,e])});test("Returns all items which match with given name",function(){this.model.set("itemGroups",i);var j=this.model.getAllItemsWithName("item 2");deepEqual(j,[{items:[e]},{items:[d],type:"buttons"}])});test("Test not manageable if no items in manageble group",function(){this.model.set("itemGroups",[{allowDelete:true,items:[]},{items:[f]}]);ok(!this.model.isManageable(),"Expected group not to be manageable")});test("Test not manageable if no allowDelete or allowReorder",function(){this.model.set("itemGroups",[{items:[]},{items:[f]}]);ok(!this.model.isManageable(),"Expected group not to be manageable")});test("Test is manageable",function(){this.model.set("itemGroups",[{items:[]},{allowDelete:true,items:[f]}]);ok(this.model.isManageable(),"Expected group to be manageable")});test("Test hasDisplayableGroups",function(){this.model.set("itemGroups",[{items:[]}]);ok(!this.model.hasDisplayableGroups());this.model.set("itemGroups",[{emptyText:"empty",items:[]}]);ok(this.model.hasDisplayableGroups());this.model.set("itemGroups",[{items:[f]}]);ok(this.model.hasDisplayableGroups())})});