define('jira/projects/sidebar/sidebar-placeholder-initializer', [
    'wrm/require',
    'jira/analytics',
    'jira/util/logger'
], function (
    wrmRequire,
    analytics,
    logger
) {

    function onError(e){
        displayErrorFlag();
        logger.error('Error while rendering sidebar. Message:', e);
        pushAnalyticsData("bigpipe.sidebar.render.error", e);
    }

    function onSuccess(e){
        pushAnalyticsData("bigpipe.sidebar.render.success", e);
    }

    function displayErrorFlag() {
        wrmRequire([
            'wr!jira.webresources:jira-formatter',
            'wr!jira.webresources:messages'
        ], function () {
            var formatter = require('jira/util/formatter');
            var flag = require('jira/flag');

            var refreshPageLink = document.createElement('a');
            refreshPageLink.setAttribute('href', '.');
            refreshPageLink.textContent = formatter.I18n.getText("project.sidebar.not.loaded.refresh.page.message");

            flag.showWarningMsg('',
                formatter.I18n.getText("project.sidebar.not.loaded.message", refreshPageLink.outerHTML));
        }).fail(function () {
            logger.error('Failed to display sidebar error message due to error when loading WRM dependencies.')
        });
    }

    function pushAnalyticsData(eventName, e) {
        var properties;
        if(e && e.data){
            properties = {
                signature: e.data.signature
            };
        }
        analytics.send({
            name: eventName,
            data: properties
        });
    }

    return {
        onSuccess: onSuccess,
        onError: onError
    };
});