define("jira/projects/sidebar/sidebar-initializer", ["require"], function(require) {
    "use strict";
    var logger = require("jira/util/logger");
    var ProjectsAPI = require("jira/api/projects");
    var SidebarAPI = require("jira/api/projects/sidebar");
    var WarningDialog = require("jira/project/types/warning/dialog");
    var LastVisitedUpdater = require("jira/projects/sidebar/lastvisited/updater");
    var SidebarComponent = require("jira/projects/sidebar/component");
    var SidebarAnalytics = require("jira/projects/sidebar/analytics/analytics");
    var SidebarAnalyticsHash = require("jira/projects/sidebar/analytics/hash");
    var wrmContextPath = require("wrm/context-path");
    var jQuery = require("jquery");
    var _ = require("underscore");

    // Keep in sync with the list in com.atlassian.jira.projects.util.PageIdHasher
    var prefixWhitelist = [
        // The constant "NONE" will represent id-less links that were clicked
        "NONE",
        "com.atlassian.jira.jira-projects-plugin:project-issue-search-link",
        "com.atlassian.jira.jira-projects-plugin:components-page",
        "com.atlassian.jira.jira-projects-plugin:reports-panel",
        "com.atlassian.jira.jira-projects-plugin:summary-panel",
        "com.atlassian.jira.jira-projects-plugin:summary-page",
        "com.atlassian.jira.jira-projects-plugin:components-page",
        "com.atlassian.jira.jira-projects-plugin:release-page",
        "com.atlassian.jira.jira-projects-plugin:release-sidebar-version-",
        "com.atlassian.jira.jira-projects-plugin:report-page",
        "com.pyxis.greenhopper.jira:global-sidebar-report",
        "com.pyxis.greenhopper.jira:global-sidebar-plan-scrum",
        "com.pyxis.greenhopper.jira:global-sidebar-work-scrum",
        "com.pyxis.greenhopper.jira:global-sidebar-work-kanban",
        "com.pyxis.greenhopper.jira:project-sidebar-plan-scrum",
        "com.pyxis.greenhopper.jira:project-sidebar-work-scrum",
        "com.pyxis.greenhopper.jira:project-sidebar-work-kanban",
        "com.pyxis.greenhopper.jira:project-invite-users-link",
        "com.pyxis.greenhopper.jira:sidebar-feedback-link",
        "com.atlassian.jira.jira-projects-issue-navigator:embedded-issue-navigator-link",
        "com.atlassian.jira.jira-projects-issue-navigator:sidebar-issue-navigator",
        "com.atlassian.jira.jira-projects-plugin:project-invite-users-link",
        "com.atlassian.jira.jira-projects-plugin:sidebar-feedback-link",
        "com.atlassian.jira.jira-one-click-invite-plugin:project-invite-users-link"
    ];

    var projectSidebarInit = function (sidebar) {
        "use strict";

        function initSidebarBadges(sidebar) {
            var badges = jQuery('.aui-sidebar .aui-badge');
            badges.tooltip({gravity: 'w'});

            if (sidebar.isCollapsed()) {
                badges.tooltip('disable');
            }

            sidebar.on('collapse-end expand-end', function () {
                jQuery(".tipsy").remove();
                jQuery('.aui-sidebar .aui-badge').tooltip('toggleEnabled');
            });
        }

        /**
         * Schedules a reflow of the sidebar, so its height is recomputed periodically.
         *
         * We need this to bring back the bottom of the sidebar, which gets lost when
         * banners get displayed on the top of the page after it's loaded.
         */
        function scheduleSidebarReflow(sidebar) {
            function reflow() {
                sidebar.getAUISidebar().reflow();
            }

            setTimeout(reflow, 200);
            setInterval(reflow, 5 * 60 * 1000);
        }

        function initDropdownCloser(sidebar) {
            sidebar.on('collapse-start', function () {
                var dropdown = sidebar.$el.find(".scope-filter-trigger");
                if (dropdown.hasClass("aui-dropdown2-active")) {
                    dropdown.trigger("aui-button-invoke");
                }
            });
        }

        function attachProjectTypesWarningDialog() {
            WarningDialog.init({
                onProjectTypeChanged: function () {
                    // we want to take the user to the summary page, just in case the project type
                    // change happens from a page for which she will have no access to after the type has changed
                    var projectKey = ProjectsAPI.getCurrentProjectKey();
                    window.location.replace(wrmContextPath() + "/projects/" + projectKey + "/summary");
                }
            });
            logger.trace("project.types.warning.messages.init");
        }

        SidebarAPI.initAPI(new SidebarComponent({el: sidebar.$el[0]}));

        _(prefixWhitelist).each(SidebarAnalyticsHash.addPrefix);
        SidebarAnalytics.register();

        initDropdownCloser(sidebar);
        initSidebarBadges(sidebar);
        attachProjectTypesWarningDialog();

        SidebarAPI.getSidebar().done(function (sidebar) {
            scheduleSidebarReflow(sidebar);
            LastVisitedUpdater.start(sidebar);
        });
    };

    return {
        init: projectSidebarInit
    };
});
