define('jira/projects/sidebar/scopefilter/model', ['underscore'], function(_) {
    'use strict';

    var Model = function(data) {
        this.selectedScope = data.selectedScope;
        this.createScopeActions = data.createScopeActions;

        if(this.selectedScope) {
            this.selectableScopes = _.reject(data.scopes, function(scope) {
                return scope.label === this.selectedScope.label && scope.link === this.selectedScope.link;
            }, this);
        } else {
            this.selectableScopes = data.scopes;
        }

        var userCanCreateAScope = this.createScopeActions.length > 0;
        var thereAreScopesToSelect = this.selectableScopes.length > 0;
        this.displayWhenSidebarIsCollapsed = userCanCreateAScope || thereAreScopesToSelect;
    };

    Model.prototype.getSelectedScope = function() {
        return this.selectedScope
    };

    Model.prototype.getSelectableScopes = function() {
        return this.selectableScopes;
    };

    Model.prototype.getCreateScopeActions = function() {
        return this.createScopeActions;
    };

    Model.prototype.shouldDisplayWhenSidebarIsCollapsed = function() {
        return this.displayWhenSidebarIsCollapsed;
    };

    return Model;
});

AJS.namespace('JIRA.Projects.Sidebar.ScopeFilter.Model', null, require('jira/projects/sidebar/scopefilter/model'));
