AJS.test.require(["com.atlassian.jira.jira-projects-plugin:collapsed-scope-filter"], function(){
    "use strict";

    var _ = require("underscore");
    var Model = require("jira/projects/sidebar/scopefilter/model");

    module("jira/projects/sidebar/scopefilter/model", {
        createScopeFilterData: function(options) {
            var scopeFilterData = {};
            scopeFilterData.scopes = [];
            scopeFilterData.createScopeActions = [];

            if(options.selectedScopeLabel) {
                scopeFilterData.selectedScope = this.createScope(options.selectedScopeLabel)
            }

            if(options.selectableScopeLabels && options.selectableScopeLabels.length > 0) {
                scopeFilterData.scopes = _.map(options.selectableScopeLabels, this.createScope);
            }

            if(options.canCreateScope) {
                scopeFilterData.createScopeActions.push(this.createScope('new'));
            }

            if(options.createActionLabels) {
                scopeFilterData.createScopeActions = _.map(options.createActionLabels, this.createScope);
            }

            return new Model(scopeFilterData);
        },

        createScope: function(label) {
            return {
                label: label,
                link: '/scopes/' + label
            }
        },

        scopeWithLabel: function(label) {
            return this.createScope(label);
        }
    });

    test("Zero scope and cannot create a new scope", function() {
        var scopeFilter = this.createScopeFilterData({});

        equal(scopeFilter.getSelectedScope(), undefined);
        equal(scopeFilter.getSelectableScopes().length, 0);
        equal(scopeFilter.getCreateScopeActions().length, 0);
        equal(scopeFilter.shouldDisplayWhenSidebarIsCollapsed(), false);
    });

    test("One scope and cannot create a new scope", function() {
        var scopeFilter = this.createScopeFilterData({
            selectedScopeLabel: "scope1",
            selectableScopeLabels: ["scope1"]
        });

        deepEqual(scopeFilter.getSelectedScope(), this.scopeWithLabel("scope1"));
        equal(scopeFilter.getSelectableScopes().length, 0);
        equal(scopeFilter.getCreateScopeActions().length, 0);
        equal(scopeFilter.shouldDisplayWhenSidebarIsCollapsed(), false);
    });

    test("Multiple scopes and cannot create a new scope", function() {
        var scopeFilter = this.createScopeFilterData({
            selectedScopeLabel: "scope2",
            selectableScopeLabels: ["scope1", "scope2"]
        });

        deepEqual(scopeFilter.getSelectedScope(), this.scopeWithLabel("scope2"));

        equal(scopeFilter.getSelectableScopes().length, 1);
        deepEqual(scopeFilter.getSelectableScopes()[0], this.scopeWithLabel("scope1"));

        equal(scopeFilter.getCreateScopeActions().length, 0);
        equal(scopeFilter.shouldDisplayWhenSidebarIsCollapsed(), true);
    });

    test("Zero scope and can create a new scope", function() {
        var scopeFilter = this.createScopeFilterData({
            canCreateScope: true
        });

        equal(scopeFilter.getSelectedScope(), undefined);
        equal(scopeFilter.getSelectableScopes().length, 0);
        equal(scopeFilter.getCreateScopeActions().length, 1);
        deepEqual(scopeFilter.getCreateScopeActions()[0], this.scopeWithLabel('new'));
        equal(scopeFilter.shouldDisplayWhenSidebarIsCollapsed(), true);
    });

    test("One scope and can create a new scope", function() {
        var scopeFilter = this.createScopeFilterData({
            selectedScopeLabel: "scope1",
            selectableScopeLabels: ["scope1"],
            canCreateScope: true
        });

        deepEqual(scopeFilter.getSelectedScope(), this.scopeWithLabel("scope1"));
        equal(scopeFilter.getSelectableScopes().length, 0);
        equal(scopeFilter.getCreateScopeActions().length, 1);
        deepEqual(scopeFilter.getCreateScopeActions()[0], this.scopeWithLabel('new'));
        equal(scopeFilter.shouldDisplayWhenSidebarIsCollapsed(), true);
    });

    test("Multiple scopes and can create a new scope", function() {
        var scopeFilter = this.createScopeFilterData({
            selectedScopeLabel: "scope1",
            selectableScopeLabels: ["scope1", "scope2"],
            canCreateScope: true
        });

        deepEqual(scopeFilter.getSelectedScope(), this.scopeWithLabel("scope1"));
        equal(scopeFilter.getSelectableScopes().length, 1);
        deepEqual(scopeFilter.getSelectableScopes()[0], this.scopeWithLabel("scope2"));
        equal(scopeFilter.getCreateScopeActions().length, 1);
        deepEqual(scopeFilter.getCreateScopeActions()[0], this.scopeWithLabel('new'));
        equal(scopeFilter.shouldDisplayWhenSidebarIsCollapsed(), true);
    });

    test("Zero scope and multiple create actions", function() {
        var scopeFilter = this.createScopeFilterData({
            createActionLabels: ["new1", "new2"]
        });

        equal(scopeFilter.getSelectedScope(), undefined);
        equal(scopeFilter.getSelectableScopes().length, 0);
        equal(scopeFilter.getCreateScopeActions().length, 2);
        deepEqual(scopeFilter.getCreateScopeActions()[0], this.scopeWithLabel('new1'));
        deepEqual(scopeFilter.getCreateScopeActions()[1], this.scopeWithLabel('new2'));
        equal(scopeFilter.shouldDisplayWhenSidebarIsCollapsed(), true);
    });

    test("One scope and multiple create actions", function() {
        var scopeFilter = this.createScopeFilterData({
            selectedScopeLabel: "scope1",
            selectableScopeLabels: ["scope1"],
            createActionLabels: ["new1", "new2"]
        });

        deepEqual(scopeFilter.getSelectedScope(), this.scopeWithLabel("scope1"));
        equal(scopeFilter.getSelectableScopes().length, 0);
        equal(scopeFilter.getCreateScopeActions().length, 2);
        deepEqual(scopeFilter.getCreateScopeActions()[0], this.scopeWithLabel('new1'));
        deepEqual(scopeFilter.getCreateScopeActions()[1], this.scopeWithLabel('new2'));
        equal(scopeFilter.shouldDisplayWhenSidebarIsCollapsed(), true);
    });

    test("Multiple scopes and multiple create actions", function() {
        var scopeFilter = this.createScopeFilterData({
            selectedScopeLabel: "scope1",
            selectableScopeLabels: ["scope1", "scope2"],
            createActionLabels: ["new1", "new2"]
        });

        deepEqual(scopeFilter.getSelectedScope(), this.scopeWithLabel("scope1"));
        equal(scopeFilter.getSelectableScopes().length, 1);
        deepEqual(scopeFilter.getSelectableScopes()[0], this.scopeWithLabel("scope2"));
        equal(scopeFilter.getCreateScopeActions().length, 2);
        deepEqual(scopeFilter.getCreateScopeActions()[0], this.scopeWithLabel('new1'));
        deepEqual(scopeFilter.getCreateScopeActions()[1], this.scopeWithLabel('new2'));
        equal(scopeFilter.shouldDisplayWhenSidebarIsCollapsed(), true);
    });
});
