define('jira/projects/sidebar/scopefilter/collapsed-view', [
    'jira/projects/sidebar/scopefilter/templates',
    'jira/projects/libs/marionette'
], function(Templates, Marionette) {
    'use strict';

    return Marionette.ItemView.extend({
        template: Templates.collapsedScopeList,

        serializeData: function() {
            return {
                selectedScope: this.model.getSelectedScope(),
                selectableScopes: this.model.getSelectableScopes(),
                createActions: this.model.getCreateScopeActions()
            }
        },

        onRender: function() {
            this.unwrapTemplate();
        }
    });
});

AJS.namespace('JIRA.Projects.Sidebar.ScopeFilter.CollapsedView', null, require('jira/projects/sidebar/scopefilter/collapsed-view'));
