define('jira/projects/sidebar/scopefilter/collapsed-initializer', [
    'jira/util/logger',
    'jira/projects/sidebar/scopefilter/model',
    'jira/projects/sidebar/scopefilter/templates',
    'jira/projects/sidebar/scopefilter/collapsed-controller',
    'jira/projects/libs/marionette',
    'jquery'
], function(logger, Model, Templates, CollapsedController, Marionette, jQuery) {
    'use strict';

    function createCollapsedScopeFilterContainer($sidebarContentContainer) {
        var $collapsedSidebarContainer = jQuery(Templates.collapsedContainer());
        $sidebarContentContainer.prepend($collapsedSidebarContainer);
        return $collapsedSidebarContainer;
    }

    function listenToSidebarEvents(sidebar, collapsedScopeFilterController) {
        sidebar.on('collapse-start', function() {
            collapsedScopeFilterController.render();
            logger.trace('sidebar.scopefilter.collapsed');
        });

        sidebar.on('expand-end', function() {
            collapsedScopeFilterController.remove();
        });
    }

    return Marionette.Controller.extend({
        initialize: function(options) {
            this.sidebarAPI = options.sidebarAPI;
            this.scopeFilterData = options.scopeFilterData;
            this.sidebar = options.sidebar;
            this.$sidebarContentContainer = options.$sidebarContentContainer;
        },

        run: function() {
            if(!this.sidebarAPI.isProjectSidebar()) {
                return;
            }

            var scopeFilter = new Model(this.scopeFilterData);
            if(!scopeFilter.shouldDisplayWhenSidebarIsCollapsed()) {
                return;
            }

            var $collapsedSidebarContainer = createCollapsedScopeFilterContainer(this.$sidebarContentContainer);
            var collapsedScopeFilterController = new CollapsedController({
                scopeFilter: scopeFilter,
                collapsedScopeFilterContainer: $collapsedSidebarContainer
            });
            listenToSidebarEvents(this.sidebar, collapsedScopeFilterController);
            if (this.sidebar.isCollapsed()) {
                collapsedScopeFilterController.render();
            }
        }
    });
});

AJS.namespace('JIRA.Projects.Sidebar.ScopeFilter.CollapsedInitializer', null, require('jira/projects/sidebar/scopefilter/collapsed-initializer'));
