AJS.test.require(["com.atlassian.jira.jira-projects-plugin:collapsed-scope-filter"], function(){
    "use strict";

    var jQuery = require("jquery");
    var _ = require("underscore");
    var OriginalCollapsedController = require("jira/projects/sidebar/scopefilter/collapsed-controller");
    var OriginalModel = require("jira/projects/sidebar/scopefilter/model");

    var CollapsedController;
    var Model;
    var sidebarComponent;

    module("jira/projects/sidebar/scopefilter/collapsed-initializer", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(OriginalModel.prototype, 'shouldDisplayWhenSidebarIsCollapsed');
            this.sandbox.stub(OriginalCollapsedController.prototype, 'render');
            this.sandbox.stub(OriginalCollapsedController.prototype, 'remove');

            CollapsedController = this.sandbox.spy(OriginalCollapsedController);
            Model = this.sandbox.spy(OriginalModel);
            sidebarComponent = {};
            sidebarComponent.isProjectSidebar = sinon.stub();

            this.context = AJS.test.mockableModuleContext();
            this.context.mock("jira/projects/sidebar/scopefilter/collapsed-controller", CollapsedController);
            this.context.mock("jira/projects/sidebar/scopefilter/model", Model);

            this.$fixture = jQuery('#qunit-fixture');
            this.$fixture.append('<div id="existing-child"></div>');

            this.sidebar = {
                callbacks: {},

                on: function(event, callback) {
                    this.callbacks[event] = this.callbacks[event] || [];
                    this.callbacks[event].push(callback);
                },

                trigger: function(event) {
                    this.callbacks[event] = this.callbacks[event] || [];
                    _.each(this.callbacks[event], function(callback) {
                        callback();
                    });
                },

                isCollapsed: this.sandbox.stub()
            };
            this.sandbox.spy(this.sidebar, 'on');

            var CollapsedInitializer = this.context.require("jira/projects/sidebar/scopefilter/collapsed-initializer");
            this.initializer = new CollapsedInitializer({
                sidebarAPI: sidebarComponent,
                scopeFilterData: {
                    scopes: [],
                    createScopeActions: []
                },
                sidebar: this.sidebar,
                $sidebarContentContainer: this.$fixture
            });
        },

        teardown: function() {
            this.sandbox.restore();
        }
    });

    test("Should do nothing when on a global sidebar", function(){
        sidebarComponent.isProjectSidebar.returns(false);

        this.initializer.run();

        sinon.assert.notCalled(Model);

        equal(this.$fixture.children().length, 1);
        equal(this.$fixture.children()[0].getAttribute('id'), 'existing-child');

        sinon.assert.notCalled(CollapsedController);

        sinon.assert.notCalled(this.sidebar.on);
    });

    test("Should do nothing when on a project sidebar and there is nothing the user can select from the scope filter", function(){
        sidebarComponent.isProjectSidebar.returns(true);

        this.initializer.run();

        sinon.assert.calledOnce(Model);

        equal(this.$fixture.children().length, 1);
        equal(this.$fixture.children()[0].getAttribute('id'), 'existing-child');

        sinon.assert.notCalled(CollapsedController);

        sinon.assert.notCalled(this.sidebar.on);
    });

    test("Should do initialize when on a project sidebar and there are selections available to the user in the scope filter", function(){
        sidebarComponent.isProjectSidebar.returns(true);
        Model.prototype.shouldDisplayWhenSidebarIsCollapsed.returns(true);

        this.initializer.run();

        sinon.assert.calledOnce(Model);

        equal(this.$fixture.children().length, 2);
        equal(this.$fixture.children().first().hasClass('collapsed-scope-filter-container'), true);
        equal(this.$fixture.children()[1].getAttribute('id'), 'existing-child');

        sinon.assert.calledOnce(CollapsedController);

        this.sidebar.trigger('collapse-start');
        sinon.assert.calledOnce(CollapsedController.prototype.render);

        this.sidebar.trigger('expand-end');
        sinon.assert.calledOnce(CollapsedController.prototype.remove);
    });

    test("Should render the collapsed view when the sidebar starts is initially loaded in the collapsed state", function(){
        this.sidebar.isCollapsed.returns(true);
        sidebarComponent.isProjectSidebar.returns(true);
        Model.prototype.shouldDisplayWhenSidebarIsCollapsed.returns(true);

        this.initializer.run();
        sinon.assert.calledOnce(CollapsedController.prototype.render);
    });
});
