require([
    'jira/projects/sidebar/scopefilter/collapsed-initializer',
    'jira/api/projects/sidebar',
    'wrm/data'
], function(
    CollapsedInitializer,
    SidebarAPI,
    wrmData
) {
    'use strict';

    SidebarAPI.getSidebar().done(function(sidebarAPI) {
        var scopeFilterData = wrmData.claim('scope-filter-data');
        if (scopeFilterData) {
            var initializer = new CollapsedInitializer({
                sidebarAPI: sidebarAPI,
                scopeFilterData: scopeFilterData,
                sidebar: sidebarAPI.getAUISidebar(),
                $sidebarContentContainer: sidebarAPI.getContentContainer()
            });
            initializer.run();
        }
    });
});
