define('jira/projects/sidebar/scopefilter/collapsed-controller', [
    'jira/projects/sidebar/scopefilter/collapsed-view',
    'jira/projects/libs/marionette'
], function(CollapsedView, Marionette) {
    return Marionette.Controller.extend({
        initialize: function(options) {
            this.scopeFilter = options.scopeFilter;

            // This special Region uses view.$el (as opposed to view.el), so all the nodes in the child
            // view will be appended to our element.
            var MultiElementRegion = Marionette.Region.extend({
                attachHtml: function(view) {
                    // empty the node and append new view
                    this.$el.empty().append(view.$el);
                }
            });

            this.collapsedScopeFilterContainer = new MultiElementRegion({
                el: options.collapsedScopeFilterContainer
            });
        },

        render: function() {
            var view = new CollapsedView({
                model: this.scopeFilter
            });
            this.collapsedScopeFilterContainer.show(view);
        },

        remove: function() {
            this.collapsedScopeFilterContainer.empty();

            //Unfortunately, we also need to do this as well because the previous line might fail
            //due to AUI inline dialog moving elements around.
            this.collapsedScopeFilterContainer.$el.empty();
        }
    });
});

AJS.namespace('JIRA.Projects.Sidebar.ScopeFilter.CollapsedController', null, require('jira/projects/sidebar/scopefilter/collapsed-controller'));
