AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-project-shortcuts"], function(){
    "use strict";

    var jQuery = require("jquery");
    var Backbone = require("backbone");

    var callbackList = {};

    module('jira/projects/sidebar/project-shortcuts/views/list', {
        setup: function () {
            this.context = AJS.test.mockableModuleContext();

            var sidebarComponent = {};
            sidebarComponent.getGroup = sinon.stub().returns({
                getItem: sinon.stub().returns({})
            });
            sidebarComponent.replaceGroup = sinon.stub();
            // stub out a cheap event system
            sidebarComponent.on = function (eventName, cb) {
                callbackList[eventName] = cb;
            };
            // just so the event handlers get collected in one place
            sidebarComponent.getAUISidebar = sinon.stub().returns(sidebarComponent);

            var sidebarAPI = {};
            sidebarAPI.initAPI = sinon.stub();
            sidebarAPI.getSidebar = sinon.stub().returns({
                done: sinon.stub().yields(sidebarComponent)
            });

            this.mockCollection = new Backbone.Collection();
            this.addDialogStub = sinon.stub();

            this.context.mock("jira/api/projects/sidebar", sidebarAPI);
            this.context.mock("jira/projects/sidebar/project-shortcuts/dialogs/add", this.addDialogStub);
            var PSListView = this.context.require("jira/projects/sidebar/project-shortcuts/views/list");

            this.view = new PSListView({
                collection: this.mockCollection
            });
            this.view.listenTo = sinon.spy();
            this.view.render();
        },
        teardown: function () {
            callbackList = {};
        }
    });

    test('Should instantiate add dialog on render.', function () {
        ok(this.addDialogStub.calledWithNew());
    });

    test('Should hide description when collection changes from 0 to n items', function () {
        ok(!this.view.ui.description.hasClass("hidden"), "Description is not hidden");
        ok(this.view.$el.hasClass("project-shortcuts-group_empty"), "Whole group is as marked empty");

        this.mockCollection.add(new Backbone.Model());

        ok(this.view.ui.description.hasClass("hidden"), "Description is hidden");
        ok(!this.view.$el.hasClass("project-shortcuts-group_empty"), "Whole group is not as marked empty");

        this.mockCollection.add(new Backbone.Model());
        this.mockCollection.add(new Backbone.Model());

        ok(this.view.ui.description.hasClass("hidden"), "Description is hidden");
        ok(!this.view.$el.hasClass("project-shortcuts-group_empty"), "Whole group is not as marked empty");

    });

    test('Should show description when collection changes from n to 0 items', function () {
        var model = new Backbone.Model();
        this.mockCollection.add(model);

        ok(this.view.ui.description.hasClass("hidden"), "Description is hidden");
        ok(!this.view.$el.hasClass("project-shortcuts-group_empty"), "Whole group is not as marked empty");

        this.mockCollection.remove(model);

        ok(!this.view.ui.description.hasClass("hidden"), "Description is not hidden");
        ok(this.view.$el.hasClass("project-shortcuts-group_empty"), "Whole group is as marked empty");
    });

    function simulateEventExpandEnd () {
        callbackList['expand-end']();
    }

    function countInlineDialogDropdown($qunitFixture) {
        return $qunitFixture.find('.aui-sidebar-submenu-dialog .project-shortcuts-group__dropdown').length;
    }

    test('Should remove any project-shortcuts-dropdown from the sidebar inline dialog', function(){
        var $qunitFixture = jQuery('#qunit-fixture');
        $qunitFixture.append('<div class="aui-sidebar-submenu-dialog"> <div class="project-shortcuts-group__dropdown"></div></div>');

        ok(countInlineDialogDropdown($qunitFixture) > 0, "Inline-dialog's dropdown should have been created but wasn't");

        simulateEventExpandEnd();

        ok(countInlineDialogDropdown($qunitFixture) == 0, "Inline-dialog's dropdown should have been removed but wasn't");
    });
});

