define('jira/projects/sidebar/project-shortcuts/views/shortcut', [
    "jira/projects/sidebar/project-shortcuts/templates",
    "jira/projects/sidebar/project-shortcuts/services/available-icons",
    "jira/projects/sidebar/project-shortcuts/dialogs/edit",
    "jira/projects/sidebar/project-shortcuts/dialogs/delete",
    "jira/projects/libs/marionette",
    "underscore",
    "jquery"
], function(
    Templates,
    AvailableIcons,
    PSEditDialog,
    PSDeleteDialog,
    Marionette,
    _,
    jQuery
) {
    "use strict";

    return Marionette.ItemView.extend({
        template: Templates.shortcut,
        initialize: function initialize() {
            _.bindAll(this, 'toggleDropdown');
            this.iconFactory = AvailableIcons;
        },
        ui: {
            del: '.project-shortcuts-group__actions__delete',
            edit: '.project-shortcuts-group__actions__edit',
            trigger: '.project-shortcuts-group__actions',
            dropdown: '.project-shortcuts-group__dropdown',
            link: '.project-shortcuts-group__link'
        },
        modelEvents: {
            'change': 'render'
        },
        events: {
            'click @ui.link': function onLinkClick() {
                this.trigger('click:link', this.model);
            }
        },
        onRender: function() {
            var instance = this;
            this.unwrapTemplate();
            var $window = jQuery(window);
            var $sidebarBody = jQuery('.aui-sidebar-body');

            this.ui.edit.on('click', function onEdit(e) {
                e.preventDefault();
                instance.ui.trigger.blur();
                var editDialog = new PSEditDialog({
                    model: instance.model
                });
                instance.trigger('edit:open', instance.model);

                instance.listenToOnce(editDialog, 'dialog:close', function onDialogClosed(isSave) {
                    instance.trigger('edit:close', instance.model, isSave);
                });
            });
            this.ui.del.on('click', function onDelete(e) {
                e.preventDefault();
                instance.ui.trigger.blur();
                var deleteDialog = new PSDeleteDialog({
                    model: instance.model
                });
            });
            this.ui.dropdown.on({
                "aui-dropdown2-show": function() {
                    instance.$el.addClass('aui-nav-selected');
                    $sidebarBody.one('scroll', instance.toggleDropdown);
                    $window.one('scroll', instance.toggleDropdown);
                    // focus on trigger, so it handle all keyboard events
                    instance.ui.trigger.focus();
                },
                "aui-dropdown2-hide": function() {
                    instance.$el.removeClass('aui-nav-selected');
                    $sidebarBody.off('scroll', instance.toggleDropdown);
                    $window.off('scroll', instance.toggleDropdown);
                }
            });
        },

        serializeData: function () {
            var data = _.extend(this.model.toJSON(), {
                canManage: true,
                isWithIcon: this.iconFactory.isWithIcons()
            });
            if (this.iconFactory.isWithIcons()) {
                data = _.extend(data, {
                    iconsMap: AvailableIcons.getIconsMap()
                });
            }

            return data;
        },
        toggleDropdown: function toggleDropdown() {
            this.ui.trigger.trigger("aui-button-invoke");
        }
    });
});

AJS.namespace('JIRA.Projects.Sidebar.ProjectShortcuts.Views.Shortcut', null, require('jira/projects/sidebar/project-shortcuts/views/shortcut'));
