AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-project-shortcuts"], function(){
    "use strict";

    var jQuery = require("jquery");
    var Marionette = require("jira/projects/libs/marionette");
    var PSShortcutView;

    var deleteDialogStub = sinon.stub();
    var editDialogStub = sinon.stub();

    module('jira/projects/sidebar/project-shortcuts/views/shortcut', {
        setup: function () {
            this.context = AJS.test.mockableModuleContext();
            this.context.mock("jira/projects/libs/marionette", Marionette);
            this.context.mock("jira/projects/sidebar/project-shortcuts/dialogs/delete", deleteDialogStub);
            this.context.mock("jira/projects/sidebar/project-shortcuts/dialogs/edit", editDialogStub);

            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(Marionette.ItemView.prototype, 'serializeData').returns({
                id: "1",
                url: "url",
                name: "name"
            });

            this.mockModel = {
                set: sinon.stub(),
                save: sinon.stub(),
                clear: sinon.stub(),
                on: sinon.stub(),
                off: sinon.stub(),
                listenTo: sinon.stub(),
                toJSON: sinon.stub().returns({})
            };
            PSShortcutView = this.context.require("jira/projects/sidebar/project-shortcuts/views/shortcut");
            this.view = new PSShortcutView({
                model: this.mockModel
            });
            this.view.listenToOnce = sinon.spy();

            this.view.render();
            this.$el = jQuery('<div class="aui-sidebar-body"></div>');
            this.$el.append(this.view.$el);
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    test('Should open delete dialog on dropdown item click.', function () {
        this.view.ui.trigger.click();
        this.view.ui.del.click();

        ok(deleteDialogStub.calledWithNew(), "Edit dialog is instantiated");
    });

    test('Should open edit dialog on dropdown item click.', function () {
        this.view.ui.trigger.click();
        this.view.ui.edit.click();

        ok(editDialogStub.calledWithNew());
    });

    /**
     * We had to make this test asynchronous in order to let the AUI process to initialise the elements
     * before the test can call their methods
     */
    asyncTest('Should select element on dropdown open.', function() {
        this.$el.appendTo("#qunit-fixture");
        setTimeout(function () {
            ok(!this.view.$el.hasClass('aui-nav-selected'), "Element is not selected");

            this.view.ui.trigger.click();

            ok(this.view.$el.hasClass('aui-nav-selected'), "Element is selected");
            start();
        }.bind(this), 1);
    });

    test('Should deselect element on dropdown hide.', function () {
        this.view.ui.trigger.click();
        this.view.ui.trigger.click();

        ok(!this.view.$el.hasClass('aui-nav-selected'),"Element is not selected");
    });
});

