AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-project-shortcuts"],function(){var d=require("jira/projects/libs/marionette");var c=require("backbone");var b=require("jira/projects/sidebar/project-shortcuts/services/available-icons");var a=require("jira/projects/sidebar/project-shortcuts/templates");module("jira/projects/sidebar/project-shortcuts/views/dialog-content",{setup:function(){this.context=AJS.test.mockableModuleContext();this.mockFlag=sinon.stub();this.context.mock("jira/flag",this.mockFlag);this.context.mock("jira/projects/sidebar/project-shortcuts/services/available-icons",b);this.context.mock("jira/projects/sidebar/project-shortcuts/templates",a);this.mockModel=new c.Model();this.mockModel.save=sinon.stub();this.mockModel.clear=sinon.stub();this.mockModel.set({name:"",icon:"",url:""});this.mockErrorModel=new c.Model();var e=this.context.require("jira/projects/sidebar/project-shortcuts/views/dialog-content");this.view=new e({template:a.addDialog,model:this.mockModel,errorModel:this.mockErrorModel});this.initializeIcons();this.view.render()},stubSerializeData:function(){this.stub(d.ItemView.prototype,"serializeData").returns({})},expectNameValueOnUrlBlur:function(f,e){this.view.ui.url.val(f);this.view.ui.url.trigger("blur");equal(this.view.ui.name.val(),e)},initializeIcons:function(){var f=[];for(var e=0;e<10;e++){f.push({className:"class"+e,name:"name"+e})}b.initialize(f);b.setWithIcons(true)}});test("Should disable all inputs and show spinner when save starts.",function(){this.mockModel.trigger("save:start");ok(this.view.$(":input").is(":disabled"));ok(this.view.ui.submit.hasClass("loading"));equal(this.view.ui.submit.find(".spinner").length,1)});test("Should enable all inputs and hide spinner when save finishes.",function(){this.mockModel.trigger("save:start");this.mockModel.trigger("save:finish");ok(this.view.$(":input").is(":enabled"));ok(!this.view.$("#project-shortcuts-submit").hasClass("loading"));equal(this.view.$("#project-shortcuts-submit .spinner").length,0)});test("Should render field errors when save fails.",function(){this.stubSerializeData();this.mockErrorModel.set({urlError:"url error",nameError:"name error"});this.mockModel.trigger("save:failure");equal(this.view.$(".error").length,2);equal(this.view.$(".error:first").text(),"url error");equal(this.view.$(".error:last").text(),"name error")});test("Should show global error flag when save fails.",function(){this.stubSerializeData();this.mockErrorModel.set("generalError","auth error");this.mockModel.trigger("save:failure");sinon.assert.calledOnce(this.mockFlag);sinon.assert.calledWith(this.mockFlag,{type:"error",title:"project.shortcuts.dialog.error.general.save",close:"auto",body:"auth error"});this.mockErrorModel.set("generalError","global error");this.mockModel.trigger("save:failure");sinon.assert.calledTwice(this.mockFlag);sinon.assert.calledWith(this.mockFlag,{type:"error",title:"project.shortcuts.dialog.error.general.save",close:"auto",body:"global error"})});test("Should clear the model on cancel.",function(){this.view.ui.cancel.click();sinon.assert.calledOnce(this.mockModel.clear)});test("Should replicate name as url after cancel.",function(){this.view.setNameAutomagically=false;this.view.ui.cancel.click();ok(this.view.setNameAutomagically)});test("Should trigger cancel event.",function(){var e=sinon.stub();this.view.on("cancel",e);this.view.ui.cancel.click();sinon.assert.calledOnce(e)});test("Should save the model on form submit.",function(){this.view.ui.url.val("url test");this.view.ui.url.trigger("input");this.view.ui.name.val("name test");this.view.ui.name.trigger("input");this.view.getRegion("iconPicker").currentView.ui.iconPicker.data("projectShortcutsIconsId","icon test");this.view.ui.form.submit();equal(this.mockModel.get("url"),"http://url test");equal(this.mockModel.get("name"),"name test");equal(this.mockModel.get("icon"),"icon test");sinon.assert.calledOnce(this.mockModel.save)});test("Should ensure prefix and automatic label on form submit.",function(){this.view.ui.url.val("test.pl/asd");this.view.ui.form.submit();equal(this.view.ui.url.val(),"http://test.pl/asd");equal(this.view.ui.name.val(),"test.pl")});test("Should add http:// prefix to the url without protocol on blur.",function(){var f=(function(j,h){var i=(h)?notEqual:equal;this.view.ui.url.val(j);this.view.ui.url.trigger("blur");i(this.view.ui.url.val(),j)}).bind(this);var g=function(h){f(h)};var e=function(h){f(h,true)};g("http://test");g("https://test");g("hipchat:test");g("callto:test");g("callto:");g(" callto:");e("www.test.com/x:10");this.view.ui.url.val("url test");this.view.ui.url.trigger("blur");equal(this.view.ui.url.val(),"http://url test")});test("Should set link label to the value of url without prefix and only up to slash.",function(){this.expectNameValueOnUrlBlur("test.pl","test.pl");this.expectNameValueOnUrlBlur("http://test.pl","test.pl");this.expectNameValueOnUrlBlur("callto:test","test");this.expectNameValueOnUrlBlur("test.pl/suffix","test.pl");this.expectNameValueOnUrlBlur(" test.pl/suffix","test.pl");this.expectNameValueOnUrlBlur("http://test.pl/suffix","test.pl");this.expectNameValueOnUrlBlur("http://","");this.expectNameValueOnUrlBlur("callto:","")});test("Should not alter name value if user touched it.",function(){this.expectNameValueOnUrlBlur("test.pl","test.pl");this.view.ui.name.val("changed");this.view.ui.name.trigger("input");this.expectNameValueOnUrlBlur("different.pl","changed")})});