AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-project-shortcuts"], function(){
    "use strict";

    var AvailableIcons = require("jira/projects/sidebar/project-shortcuts/services/available-icons");

    module('jira/projects/sidebar/project-shortcuts/services/available-icons', {
        setup: function () {
            this.availableIcons = AvailableIcons;
            this.iconsList = [];

            for (var i = 0; i < 10; i ++){
                this.iconsList.push({
                    className: 'class' + i,
                    name: 'name' + i
                });
            }
            this.availableIcons.initialize(this.iconsList);
            this.availableIcons.setWithIcons(true);
        }
    });

    test('Should return first icon if name does not exist.', function () {
        var icon = this.availableIcons.getIconFromName('invalid name');
        ok(icon.className, this.iconsList[0].className);
        ok(icon.name, this.iconsList[0].name);
    });

    test('Method getAllIconsClasses should return all icons classes.', function() {
        var allIconsClasses = this.availableIcons.getAllIconsClasses().split(' ');

        for (var i = 0; i < 10; i++) {
            ok(allIconsClasses.indexOf("class" + i) > -1);
        }
    });
});

